% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.metarep.R
\name{print.summary.metarep}
\alias{print.summary.metarep}
\title{Print detailed meta-analysis with replicability-analysis results}
\usage{
\method{print}{summary.metarep}(x, details.methods = TRUE, ...)
}
\arguments{
\item{x}{An object of class 'summary.metarep'}

\item{details.methods}{A logical specifying whether details on
statistical methods should be printed}

\item{...}{Arguments to be passed to methods, see \code{print.summary.meta}}
}
\value{
No return value, called for side effects.
}
\description{
Print method for objects of class 'summary.metarep'.
}
\examples{
n.i.1 <- c( 20, 208, 24, 190, 58, 36, 51)
a.i <- c( 2,79,0,98,15,34,9) 
n.i.2 <- c( 20, 119, 22, 185, 29, 51, 47)
c.i <- c(9,106,14,98,12,49,9) 
m1 <- metabin( event.e = a.i,n.e = n.i.1,event.c = c.i,n.c = n.i.2,
               studlab = paste0('Study ' , 1:7) , sm = 'OR' ,
               common = FALSE, random = TRUE )
mr1 <- metarep(  m1 , u = 2, common.effect = FALSE , t = 0.05 , 
               alternative = 'two-sided', report.u.max = TRUE) 
print(summary(mr1), digits = 2)
}
