% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.copas.R
\name{summary.copas}
\alias{summary.copas}
\title{Summary method for Copas selection model}
\usage{
\method{summary}{copas}(object, level = 0.95,
  sign.rsb = object$sign.rsb, ...)
}
\arguments{
\item{object}{An object of class \code{copas}.}

\item{level}{The level used to calculate confidence intervals
(between 0 and 1).}

\item{sign.rsb}{The significance level for the test of residual
selection bias (between 0 and 1).}

\item{...}{other arguments to the function will be ignored (this
option included only to conform with R standards)}
}
\value{
An object of class "summary.copas" with corresponding print
  function. The object is a list containing the following
  components:

\item{slope}{Results for points on orthogonal line (a list with
  elements TE, seTE, lower, upper, z, p, level).}
\item{publprob}{Vector of probabilities of publishing the smallest
  study.}
\item{pval.rsb}{P-values for tests on presence of residual
  selection bias}
\item{N.unpubl}{Approximate number of studies the model suggests
  remain unpublished}
\item{adjust}{Result of Copas selection model adjusted for
  selection bias (a list with elements TE, seTE, lower, upper, z,
  p, level).}
\item{sign.rsb}{The significance level for the test of residual
  selection bias.}
\item{pval.rsb.adj}{P-value for test on presence of residual
  selection bias for adjusted effect given in \code{adjust}.}
\item{N.unpubl.adj}{Approximate number of studies the model
  suggests remain unpublished for adjusted effect given in
  \code{adjust}}
\item{random}{Results for usual random effects model (a list with
  elements TE, seTE, lower, upper, z, p, level).}
\item{sm}{A character string indicating underlying summary
  measure.}
\item{ci.lab}{Label for confidence interval.}
\item{title}{Title of meta-analysis / systematic review.}
\item{complab}{Comparison label.} \item{outclab}{Outcome label.}
\item{version}{Version of R package metasens used to create
  object.}
}
\description{
Summary method for objects of class \code{copas}.
}
\details{
This function complements the graphical summary of the results of a
Copas selection model, generated using \code{plot.copas}.
}
\examples{
data(Fleiss93)

# Perform meta analysis, effect measure is odds ratio (OR)
#
m1 <- metabin(event.e, n.e, event.c, n.c, data = Fleiss93, sm = "OR")

# Print summary of Copas analysis
#
summary(copas(m1), level = 0.95)

}
\seealso{
\code{\link{copas}}, \code{\link{plot.copas}},
\code{\link[meta]{metabias}}, \code{\link[meta]{metagen}}
}
\author{
James Carpenter \email{James.Carpenter@lshtm.ac.uk}, Guido
Schwarzer \email{sc@imbi.uni-freiburg.de}
}
