#' Fits Markov Chain Transition Matrices to State Sequence Modified from
#' weathergen
#'
#' Fits Markov Chain Transition Matrices to State Sequence Modified from
#' weathergen
#'
#'
#' @param states character array of states (from 'd','w','e', for dry, wet and
#' extremely wet)
#' @param months numeric array of months for each daily time step
#' @return monthly list of transition matrices
#' @examples
#' \donttest{
#' transitions <- mc_fit(x=sample(c('d', 'w', 'e'), size=720, replace=TRUE, prob=c(0.5, 0.3, 0.2)), months=rep(rep(seq(1, 12), each=30), times=2))
#' }
#' @noRd
.mc_fit<-function(states, months) {
  # stopifnot(length(states) == length(months))
  # ns <- 3
  # s  <- c('d','w','e')
  # states <- as.character(states)
  # states_next <- c(states[2:length(states)],NA)
  # transitions <- lapply(seq(1, 12), function(m) {
  #   idx <- which(months==m)
  #   t = matrix(0, 3,3,dimnames = list(s,s))
  #   for(i in 1:ns) for(j in 1:ns) t[i,j] = sum(states[idx]==s[i] & states_next[idx]==s[j], na.rm=T)
  #   t<-sweep(t, 1, rowSums(t, na.rm=T),"/")
  #   t[is.na(t)] <- 0
  #   t
  # })
  # transitions
}


#' Run Markov Chain Simulation
#'
#' Run Markov Chain Simulation
#'
#'
#' @param months numeric array of months for each daily time step
#' @param initial initial state
#' @param transitions monthly list of transition matrices generated by mc_fit()
#' @examples
#' \donttest{
#' transitions <- mc_fit(x=sample(c('d', 'w', 'e'), size=720, replace=TRUE, prob=c(0.5, 0.3, 0.2)),
#'                       months=rep(rep(seq(1, 12), each=30), times=2))
#' mc_simulate(months=rep(1:12, each=30), initial='d', transitions=transitions, states=c('d', 'w', 'e'))
#' }
#'
#' @noRd
.mc_sim<-function(months, initial, transitions) {
  # n <- length(months)
  #
  # states <- as.character(rownames(transitions[[1]]))
  # chain <- as.character(rep(NA, times=n))
  # chain[1] <- as.character(initial)
  #
  # for (i in 2:n) {
  #   tm <- transitions[[months[i-1]]]
  #   p <- as.numeric(tm[which(states==chain[i-1]), ])
  #   chain[i] <- sample(states, size=1, prob=p)
  # }
  # return(chain)
}




#' Determine Markov State Thresholds from Precipitation
#'
#' Determine Markov State Thresholds from Precipitation
#'
#'
#' @param x vector of daily precipitation
#' @param months vector of months corresponding to daily precipitation vector
#' \code{x}
#' @param dry_wet_threshold threshold precipitation amount for dry/wet states
#' @param wet_extreme_quantile_threshold threshold quantile for wet/extreme
#' states
#' @return monthly list of precipitation thresholds as vectors of length 2
#' (first element is threshold amount between dry/wet, second element is
#' threshold amount between wet/extreme)
#' @noRd
.mc_state_threshold <- function(x, months, dry_wet_threshold=0.3, wet_extreme_quantile_threshold=0.8) {
  # stopifnot(any(!is.na(x)))
  # stopifnot(any(!is.na(months)))
  # stopifnot(length(x) == length(months))
  #
  # thresh <- lapply(seq(1, 12), function(month) {
  #   idx <- which(months == month)
  #   if (length(idx) > 0) {
  #     x.month <- x[idx]
  #     x.month <- x.month[x.month>dry_wet_threshold]
  #     if(length(x.month)>0) wet_extreme_threshold <- as.numeric(quantile(x.month, probs=wet_extreme_quantile_threshold))
  #     else wet_extreme_threshold = dry_wet_threshold + 0.1
  #     res <- c(dry_wet=dry_wet_threshold, wet_extreme = wet_extreme_threshold)
  #   } else {
  #     res <- c(dry_wet=NA, wet_extreme=NA)
  #   }
  #   res
  # })
  #
  # thresh
}



#' Assign Markov States from Precipitation and State Thresholds
#'
#' Assign Markov States from Precipitation and State Thresholds
#'
#'
#' @param x vector of daily precipitation
#' @param months vector of months corresponding to daily precipitation
#' @param thresholds list of monthly transition matrices generated from
#' mc_fit()
#' @param states character list of markov states
#' @noRd
.mc_assign_states <- function(x, months, thresholds) {
  # stopifnot(length(x)==length(months))
  # stopifnot(length(thresholds)==12)
  #
  # states <- c('d','w','e')
  # state <- lapply(seq(1, 12), function(month) {
  #   idx <- which(months == month)
  #   if (length(idx) > 0) {
  #     x.month <- x[idx]
  #     res <- cut(x.month, breaks=c(0, thresholds[[month]], Inf), include.lowest=TRUE, right=TRUE, labels=states)
  #   } else {
  #     res <- character()
  #   }
  #   res
  # })
  # return(as.character(unlist(state)))
}

# Apipattanavis, S., G. Podesta, B. Rajagopalan, and R. W. Katz (2007), A
# semiparametric multivariate and multisite weather generator, Water
# Resour. Res., 43, W11401, doi:10.1029/2006WR005714.
.mcknn_weathergeneration<-function(x, ndays = NULL, params = defaultGenerationParams()) {

  # months = x$Month
  # # print(sum(is.na(months)))
  # if(is.null(ndays)) ndays = length(months)
  # prec = x$Precipitation
  # sd_prec = sd(prec)
  # meantemp = x$MeanTemperature
  # sd_meantemp = sd(meantemp)
  # thresh <- .mc_state_threshold(prec, months,
  #                               dry_wet_threshold = params$dry_wet_threshold,
  #                               wet_extreme_quantile_threshold = params$wet_extreme_quantile_threshold)
  # states <- .mc_assign_states(prec, months, thresh)
  # # print(thresh)
  # statePrev <- c(NA, states[1:(length(states)-1)])
  # transition <- .mc_fit(states, months)
  # # print(transition)
  # #Set variable weights
  # w_prec = 100/sd_prec
  # w_meantemp = 10/sd_meantemp
  #
  # #Initialize selected days
  # initial <- sample(which(months == months[1]),1)
  # #Generate Precipitation State Series of M day length
  # pss <- .mc_sim(months[1:ndays], states[initial], transition)
  #
  # #Initialize vector of selected days
  # days <-initial
  #
  # prevSelectedDay <- initial
  # for(ic in 2:length(pss)) {
  #   # cat(paste0("ic", ic,":\n"))
  #   #Select days centered on the same DOY that have the same sequence of states simulated by the MC for day t and t-1
  #   rangeSize = params$range_size_days -1
  #   sel = rep(FALSE, length(states))
  #   while(sum(sel)==0) {
  #     rangeSize = rangeSize+1
  #     doyIC = x$DOY[ic]
  #     doyrange <- (doyIC-rangeSize):(doyIC+rangeSize)
  #     doyrange[doyrange<0] <- (365 + doyrange[doyrange<0])
  #     sel = (x$DOY %in% doyrange) & (states == pss[ic]) & (statePrev == states[ic-1])
  #     sel[1] = FALSE
  #   }
  #   selDays <- which(sel)
  #   Q <- sum(sel)
  #   # cat(paste0("Q", Q,"rs", rangeSize,"\n"))
  #   k <- ceiling(sqrt(Q))
  #   #Calculate weighted euclidean distances
  #   dq <- sqrt(w_prec*((prec[prevSelectedDay] - prec[selDays-1])^2)+
  #                w_meantemp*((meantemp[prevSelectedDay] - meantemp[selDays-1])^2))
  #   o <- order(dq)
  #   sel_knn <- (dq <= dq[o[k]])
  #   selDays = selDays[sel_knn]
  #   dq = dq[sel_knn]
  #   o = order(dq)
  #   w_kernel <- (1/o)/sum(1/o)
  #   d <- selDays[sample(1:length(selDays), size=1, prob=w_kernel)]
  #   days = c(days, d)
  #   prevSelectedDay = d
  # }
  # return(days)
}



#' Run simulation of an arima model
#'
#' Run simulation of an arima model
#'
#'
#' @param model arima model object
#' @param n number of simulation timesteps
#' @importFrom stats arima.sim coef
#' @noRd
.arima_simulate <- function(model, n) {
  # sim <- arima.sim(n=n,
  #                  list(ar=coef(model)[grepl('ar', names(coef(model)))],
  #                       ma=coef(model)[grepl('ma', names(coef(model)))]),
  #                  sd = sqrt(model$sigma2[[1]]))
  #
  # # extract intercept
  # if ('intercept' %in% names(model$coef)) {
  #   intercept <- model$coef['intercept']
  # } else {
  #   intercept <- 0
  # }
  #
  # # add intercept (mean) to current simulation
  # sim <- sim + intercept
  #
  # return(as.numeric(sim))
}



#' Select k-Nearest Neighbor for Annual Simulation
#'
#' Select k-Nearest Neighbor for Annual Simulation
#'
#'
#' @param prcp target annual precipitation (scalar)
#' @param obs_prcp historical annual precipitation
#' @param n number of years to sample
#' @return vector of sampled years of length n
#' @noRd
.knn_annual <- function(prcp, obs_prcp, n=100) {
  # stopifnot(length(prcp)==1)
  # stopifnot(all(!is.na(obs_prcp)))
  #
  # k <- round(max(sqrt(length(obs_prcp)), 0.5*length(obs_prcp)), 0)
  # stopifnot(k > 0)
  #
  # df <- data.frame(YEAR=as.numeric(format(as.Date(names(obs_prcp)),"%Y")),
  #                  PRCP=as.numeric(obs_prcp))
  #
  # # compute distances
  # df[, 'DISTANCE'] <- sqrt((prcp - df[['PRCP']])^2)
  # df <- df[order(df[['DISTANCE']]), ]
  #
  # # select k nearest
  # df <- df[1:min(nrow(df), k), ]
  #
  # # compute sampling probabilities
  # df[, 'ROW'] <- 1:nrow(df)
  # df[, 'PROB'] <- (1/df[, 'ROW'])/(sum(1/df[, 'ROW']))
  # stopifnot(abs(sum(df[['PROB']])-1) < 1e-7)
  #
  # selection <- sample(1:nrow(df), size=n, prob=df[['PROB']], replace=TRUE)
  # as.numeric(df[['YEAR']][selection])
}



#' Weather generation
#'
#' @description
#' `r lifecycle::badge("deprecated")`
#'
#' A semiparametric multivariate, multisite weather generator. The algorithm
#' can be interpreted as a way to resample the original data to create
#' synthetic data sets of the same length and similar properties.
#'
#' @details
#' The implemented algorithm is based on Apipattanavis et al. (2007) for the
#' non-conditional version, and is similar to Steinschneider et al. (2013) for
#' the conditional one. Part of the code was adapted from package 'weathergen'
#' by Jeffrey D. Walker, whom we are grateful. Conditioning is controlled via
#' the element \code{conditional} of \code{params} list, which can be:
#' \itemize{ \item\code{"none"} - The non-conditional version is used, which is
#' based on a first order Markov chain (MC) to simulate weather states
#' (dry/wet/extreme wet) and a K-nearest neighbour (KNN) algorithm to select
#' pairs of days with the same transition and similar weather for the initial
#' state (as in Apipattanavis et al. 2007). \item\code{"arima"} - Annual
#' precipitation is conditioned using a stationary auto-regressive (ARIMA)
#' model and then a K-nearest neighbour algorithm is used to select a set of
#' years to train the MC-KNN algorithm (similar to Steinschneider et al. 2013).
#' Recommended if low-frequency variation of annual precipitation is to be
#' accounted for in long series. \item\code{"window"} - The MC-KNN algorithm is
#' trained with the subset of the input data corresponding to a window around
#' the target year. Annual precipitation is conditioned using a lognormal
#' random trial of the precipitation corresponding to the selected years.
#' Recommended to generate stochastic series from climate change projections. }
#'
#' @param object An object of class
#' \code{\link{SpatialPointsMeteorology-class}},
#' \code{\link{SpatialGridMeteorology-class}} or
#' \code{\link{SpatialPixelsMeteorology-class}}.
#' @param params A list with parameters for the weather generator (see
#' \code{\link{defaultGenerationParams}}).
#' @param verbose Boolean flag to print process information.
#' @return An object of the same class as the input \code{object}. Generated
#' meteorological series are of the same length as the input.
#' @author Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
#' @seealso \code{\link{defaultGenerationParams}}
#' @references Apipattanavis, S., G. Podesta, B. Rajagopalan, and R. W. Katz
#' (2007), A semiparametric multivariate and multisite weather generator, Water
#' Resour. Res., 43, W11401, doi:10.1029/2006WR005714.
#'
#' Steinschneider S., and Brown C. (2013) A semiparametric multivariate,
#' multisite weather generator with low-frequency variability for use in
#' climate risk assessments. Water Resour. Res., 49, 7205-7220,
#' doi:10.1002/wrcr.20528.
#'
#' @export
weathergeneration<-function(object,
                            params = defaultGenerationParams(),
                            verbose = TRUE) {

  # deprecation notice
  lifecycle::deprecate_stop(
    when = "2.0.0", what = "weathergeneration()", with = NULL,
    details = "Current weather generation methods are currently deprecated because they operate with classes that are deprecated themselves, but for future versions, we plan to keep the functionality in new functions."
  )


  # if((!inherits(object,"SpatialPointsMeteorology"))
  #    && (!inherits(object,"SpatialGridMeteorology"))
  #    && (!inherits(object,"SpatialPixelsMeteorology"))
  #    && (!inherits(object,"data.frame"))) stop("'object' has to be of class 'Spatial_*_Meteorology' or a data frame with weather data.")
  #
  # match.arg(params$conditional, c("none", "arima", "window"))
  #
  # if((inherits(object,"SpatialPointsMeteorology"))
  #    || (inherits(object,"SpatialGridMeteorology"))
  #    || (inherits(object,"SpatialPixelsMeteorology"))) {
  #   #Average weather over the area
  #   if(verbose) cat("Calculating area-averaged weather...\n")
  #   x <- averagearea(object)
  #   x <- x@data[[1]]
  # } else {
  #   x = object
  # }
  #
  #
  # # Add year and Month to daily data
  # x$Month = as.numeric(format(as.Date(row.names(x)),"%m"))
  # x$Year = as.numeric(format(as.Date(row.names(x)), "%Y"))
  #
  # if(params$conditional=="none") {
  #   if(verbose) cat("\nGenerating weather series...\n")
  #   selDays  = .mcknn_weathergeneration(x = x, params = params)
  #   selDatesYears = row.names(x)[selDays]
  #   ratiosYears = rep(1, length(selDatesYears))
  #
  #   if(params$adjust_annual_precip) {
  #     r = sum(x$Precipitation, na.rm=T)/sum(x$Precipitation[selDays], na.rm=T)
  #     r = min(max(r,params$min_ratio), params$max_ratio)
  #     ratiosYears = rep(r, length(selDatesYears))
  #   }
  #   psim = tapply(x$Precipitation[selDays]*ratiosYears, x$Year, FUN=sum, na.rm=T)
  #   ptarget = tapply(x$Precipitation, x$Year, FUN=sum, na.rm=T)
  #   if(verbose) {
  #     cat("\nAnnual precipitation stats: \n")
  #     df = data.frame(average = c(mean(ptarget),mean(psim)),
  #                     sd = c(sd(ptarget), sd(psim)),
  #                     row.names = c("input/target", "simulated"))
  #     print(df)
  #   }
  # } else {
  #   # Calculate days per year
  #   days_per_year = table(x$Year)
  #   # Calculate annual precipitation
  #   pyear = summarypoint(x, fun="sum", var = "Precipitation", freq = "year", na.rm=T)
  #   pyear= pyear[!is.na(pyear)]
  #   n_year = length(pyear)
  #   if(params$conditional=="arima"){
  #     if(verbose) cat("\nTarget annual precipitation from ARIMA model...\n")
  #     # Fit ARIMA model
  #     ar_model <- forecast::auto.arima(pyear, max.p=2, max.q=2, max.P=0, max.Q=0, stationary=TRUE)
  #     if(verbose) {
  #       print(ar_model)
  #       cat("\n")
  #     }
  #     # simulation ARIMA model
  #     target_pyear <- .arima_simulate(model=ar_model, n=n_year)
  #   } else {
  #     if(verbose) cat("\nTarget annual precipitation from moving-window...\n")
  #     # Calculate observed mean annual temperature
  #     # tyear = summarypoint(x, fun="mean", var = "MeanTemperature", freq = "year", na.rm=T)
  #     # tyear= tyear[!is.na(tyear)]
  #     target_pyear = pyear
  #   }
  #
  #   if(verbose) cat("\nGenerating weather series...\n")
  #   selDatesYears <- character()
  #   ratiosYears = numeric()
  #   if(verbose) pb = txtProgressBar(1, n_year, style=3)
  #   psim = rep(NA, n_year)
  #   ptarget = rep(NA, n_year)
  #   for(i in 1:n_year) {
  #     if(verbose) setTxtProgressBar(pb, i)
  #     # create population of years with knn
  #     if(params$conditional=="arima") {
  #       pop_years <- .knn_annual(prcp=as.numeric(target_pyear[i]), obs_prcp=pyear,
  #                                n=params$n_knn_annual)
  #     } else if (params$conditional=="window") {
  #       if((1+params$range_size_years*2) < length(pyear)) {
  #         rangeSize = params$range_size_years
  #         ymin = i-rangeSize
  #         ymax = i+rangeSize
  #         ycor = ifelse(ymin<1, 1-ymin,0)
  #         ycor = ifelse(ymax>length(pyear), length(pyear)-ymax,ycor)
  #         ymin = ymin+ycor
  #         ymax = ymax+ycor
  #         yearrange <- ymin:ymax
  #       } else {
  #         yearrange <- 1:length(pyear)
  #       }
  #       # yearrange <- yearrange[yearrange!=i]
  #       pyear_i = pyear[yearrange]
  #       # tyear_i = tyear[yearrange]
  #       target_pyear[i] <- rlnorm(n=1, meanlog = mean(log(pyear_i)), sdlog = sd(log(pyear_i)))
  #       pop_years <- .knn_annual(prcp=target_pyear[i], obs_prcp=pyear_i,
  #                                 n=params$n_knn_annual)
  #     }
  #
  #     # Assemble daily data
  #     pop_days <- lapply(pop_years, function(yr) {
  #       x[which(x$Year==yr), ]
  #     })
  #     pop_days <- do.call(rbind, pop_days)
  #     # print(dim(pop_days))
  #
  #     # Fit weather generator with daily data and generate data for one year
  #     selDays <- .mcknn_weathergeneration(pop_days, days_per_year[i], params)
  #
  #     # Extract the dates corresponding to the selected rows
  #     selDates <- substr(row.names(pop_days)[selDays],1,10)
  #     selDatesYears = c(selDatesYears, selDates)
  #     ratios<- rep(1, days_per_year[i])
  #     if(params$adjust_annual_precip) {
  #       r = target_pyear[i]/sum(pop_days$Precipitation[selDays])
  #       r = min(max(r, params$min_ratio), params$max_ratio)
  #       ratios <- rep(r, days_per_year[i])
  #     }
  #     ratiosYears = c(ratiosYears, ratios)
  #     psim[i] = sum(pop_days$Precipitation[selDays]*ratios)
  #     ptarget[i] = target_pyear[i]
  #   }
  #   cat("\n")
  #   if(verbose) {
  #     cat("\nYear-to-year precipitation comparison: \n")
  #     df = data.frame(input = pyear, target = ptarget, simulated = psim)
  #     print(df)
  #     cat("\nAnnual precipitation stats: \n")
  #     df = data.frame(average = c(mean(pyear), mean(ptarget),mean(psim)),
  #                     sd = c(sd(pyear), sd(ptarget), sd(psim)),
  #                     row.names = c("input", "target", "simulated"))
  #     print(df)
  #   }
  # }
  # y <- object
  # if(inherits(object,"SpatialPointsMeteorology")) {
  #   for(i in 1:length(object@data)) {
  #     df1 <- object@data[[i]]
  #     df2 <- df1[selDatesYears, ]
  #     df2$DOY = df1$DOY
  #     df2$Precipitation = df2$Precipitation*ratiosYears
  #     row.names(df2) = row.names(df1)
  #     y@data[[i]] = df2
  #   }
  # } else if(inherits(object,"SpatialGridMeteorology") || inherits(object,"SpatialPixelsMeteorology")) {
  #   y@data = y@data
  #   y@dates = y@dates
  #   for(i in 1:length(selDatesYears)) {
  #     y@data[[i]] <- object@data[[selDatesYears[i]]]
  #     y@data[[i]]$Precipitation = y@data[[i]]$Precipitation*ratiosYears[i]
  #   }
  # } else {
  #   y <- x[selDatesYears, ]
  #   y$DOY = x$DOY
  #   y$Precipitation = y$Precipitation*ratiosYears
  #   row.names(y) = row.names(x)
  # }
  # return(y)
}
