% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_currentday.R, R/download_historical.R,
%   R/download_stationlist.R
\name{downloadAEMETcurrentday}
\alias{downloadAEMETcurrentday}
\alias{downloadAEMETstationlist}
\alias{downloadAEMEThistorical}
\title{Download data from AEMET}
\usage{
downloadAEMETcurrentday(api, daily = TRUE, verbose = TRUE)

downloadAEMEThistorical(
  api,
  dates,
  station_id = NULL,
  export = FALSE,
  exportDir = getwd(),
  exportFormat = "meteoland/txt",
  metadataFile = "MP.txt",
  verbose = TRUE
)

downloadAEMETstationlist(api)
}
\arguments{
\item{api}{String with the AEMET API key (see https://opendata.aemet.es/).}

\item{daily}{Boolean flag. Are data to be returned at a daily or hourly
scale?}

\item{verbose}{Boolean flag to print process information.}

\item{dates}{An object of class \code{\link{Date}}.}

\item{station_id}{A string vector containing station ids (the list of
stations for which historical climatic series are available is given by
\code{downloadAEMETstationlist}).}

\item{export}{If \code{export = FALSE} the downloaded data is stored in
memory. Otherwise the result is written on the disk (using the format
specified in \code{exportFormat}).}

\item{exportDir}{Output directory for downloaded meteorology.}

\item{exportFormat}{Format of meteorological data. Current accepted formats
are \code{"castanea"} and \code{"meteoland"}.}

\item{metadataFile}{The name of the file that will store the meta data
describing all written files.}
}
\value{
Function \code{downloadAEMETstationlist} returns a
\code{SpatialPointsDataFrame} object containing the list of
AEMET weather stations for which historical climatic series are available
and can be retrieved using \code{downloadAEMEThistorical}.

Function \code{downloadAEMEThistorical} downloads data for the specified
AEMET stations and dates. Data is available for dates up to 4 days before
current date. If \code{export = FALSE}, function
\code{downloadAEMEThistorical} returns a
\code{\link{SpatialPointsMeteorology-class}} object with the downloaded
meteorology for each station (point). Otherwise the function writes on the
disk at the location specified by \code{exportDir} and solely returns a
\code{SpatialPointsDataFrame} object containing the files
metadata.

Function \code{downloadAEMETcurrentday} downloads recent weather (the last
24h) from all currently available stations and returns data frame if
\code{daily = FALSE} or a \code{SpatialPointsDataFrame} object
with observations aggregated at the daily scale if else.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Download data from the Spanish National Meterology Agency
(AEMET)
}
\details{
API key needs to be acquired from AEMET (https://opendata.aemet.es/)
}
\section{Functions}{
\itemize{
\item \code{downloadAEMEThistorical()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{downloadAEMETstationlist()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

}}
\note{
Since ver. 1.0.1, weather data download functions included in
\code{meteoland} make internal calls to functions in package
\code{meteospain}. For an enhanced flexibility, users are recommended to
call functions in \code{meteospain} themselves, and then to use function
\code{\link{reshapemeteospain}} to generate data suitable for
\code{meteoland}.

The list of stations available in \code{downloadAEMETcurrentday} (current
observations) may be different from the list given by
\code{downloadAEMETstationlist} and available in
\code{downloadAEMEThistorical} (stations with historical climate series).
}
\references{
AEMET should be acknowledged as author of information when using
this data.
}
\seealso{
\code{\link{SpatialPointsMeteorology-class}}
}
\author{
Antoine Cabon, CTFC

Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
