% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PBE.R
\name{PBE}
\alias{PBE}
\title{Percentage Bias Error (PBE).}
\usage{
PBE(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the PBE for a continuous predicted-observed dataset
following Gupta et al. (1999).
}
\details{
The PBE (\%) is useful to identify systematic over or under predictions.
It is an unbounded metric. The closer to zero the bias of predictions.
Negative values indicate overestimation, while positive values indicate underestimation.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
PBE(obs = X, pred = Y)
}
}
\references{
Gupta et al. (1999).
Status of automatic calibration for hydrologic models: Comparison with multilevel expert calibration.
\emph{J. Hydrologic Eng. 4(2): 135-143.} \doi{10.1061/(ASCE)1084-0699(1999)4:2(135)}
}
