% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bland_altman.R
\name{bland_altman_plot}
\alias{bland_altman_plot}
\title{Bland-Altman plot}
\usage{
bland_altman_plot(
  data = NULL,
  obs,
  pred,
  shape_type = NULL,
  shape_size = NULL,
  shape_color = NULL,
  zeroline_type = NULL,
  zeroline_size = NULL,
  zeroline_color = NULL,
  limitsline_type = NULL,
  limitsline_size = NULL,
  limitsline_color = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{shape_type}{number indicating the shape type for the data points.}

\item{shape_size}{number indicating the shape size for the data points.}

\item{shape_color}{string indicating the shape color for the data points.}

\item{zeroline_type}{string or integer indicating the zero line-type.}

\item{zeroline_size}{number indicating the zero line size.}

\item{zeroline_color}{string indicating the zero line color.}

\item{limitsline_type}{string or integer indicating the limits (+/- 1.96*SD) line-type.}

\item{limitsline_size}{number indicating the limits (+/- 1.96*SD) line size.}

\item{limitsline_color}{string indicating the limits (+/- 1.96*SD) line color.}

\item{na.rm}{Logic argument to remove rows with missing values}
}
\value{
an object of class \code{ggplot}.
}
\description{
It creates a scatter plot of the difference between observed and predicted
values (obs-pred) vs. observed values.
}
\details{
For more details, see \href{https://adriancorrendo.github.io/metrica/}{online-documentation}
}
\examples{
\donttest{
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 10)
bland_altman_plot(obs = X, pred = Y)
}
}
\references{
Bland & Altman (1986).
Statistical methods for assessing agreement between two methods of clinical measurement
\emph{The Lancet 327(8476), 307-310} \doi{10.1016/S0140-6736(86)90837-8}
}
\seealso{
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{aes}}
}
