% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_diver.R
\name{rich_diver}
\alias{rich_diver}
\title{Richness measures}
\usage{
rich_diver(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating indicating if progress messages should be given.}
}
\value{
This function returns a data.frame with all the calculated richness measures:
\item{n_taxa}{N° total taxa.}
\item{n_fam}{N° of families.}
\item{n_gen}{N° of genus.}
\item{n_insec_fam}{N° of insects families.}
\item{n_non_insec_order}{N° of orders of invertebrates no insects.}
\item{n_dip_fam}{N° of Diptera families.}
\item{n_dip_gen}{N° of Diptera genus.}
\item{n_dip_chir_gen}{N° of Diptera Chironomidae genus.}
\item{n_chir_tax}{N° of Diptera Chironomidae taxa.}
\item{n_tany_tax}{N° of Tanytarisni taxa.}
\item{n_stemp_tax}{N° of Stempellina taxa.}
\item{n_non_chir_dip_tax}{N° of Diptera no Chironomidae taxa.}
\item{n_mol_tax}{N° of Mollusca taxa.}
\item{n_gastr_tax}{N° of Gastropoda taxa.}
\item{n_biv_tax}{N° of Bivalvia taxa.}
\item{n_crus_tax}{N° of Crustacea taxa.}
\item{n_crusmol}{N° of Crustacea + Mollusca taxa.}
\item{n_oligo_tax}{N° of Oligochaeta taxa.}
\item{n_ephetrich}{N° of Ephemeroptera + Trichoptera taxa.}
}
\description{
Calculates trophic measures
}
\details{
The richness measures reflect the diversity of the aquatic complex (Resh et al. 1995). Increased diversity correlates with increased assemblage health and suggests that niche space, habitat, and food source are adequate to support the survival and spread of many taxa. The number of taxa measures the general variety of the macroinvertebrate assemblage. Identities of major taxonomic groups are not derived from the total taxa metric, but the removal of taxa from naturally diverse systems can be detected easily (Barbour et al., 1996).
}
\examples{
#Example data is a properly formatted table with richness measures of two sites
example_data

#Run rich_diver with that example_data
richd<-rich_diver(example_data)

#Check results
richd
}
\references{
\itemize{
\item{Resh VH, Norris RH & Barbour MT (1995) \doi{10.1111/j.1442-9993.1995.tb00525.x>}}
\item{Barbour MT, Gerritsen J, Griffith GE, Frydenborg R, McCarron E, White JS & Bastian ML (1996) \doi{10.2307/1467948>}}
}
}
\seealso{
\link[metrix]{read_data}
}
\author{
Juan Manuel Cabrera and Julieta Capeleti.
}
