% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mfgarch_diffusion.R
\name{simulate_mfgarch_diffusion}
\alias{simulate_mfgarch_diffusion}
\title{This function simulates a GARCH-MIDAS model where the short-term GARCH component is replaced by its diffusion limit, see Andersen (1998)}
\usage{
simulate_mfgarch_diffusion(n.days, mu, alpha, beta, gamma, m, theta, w1 = 1,
  w2, K, psi, sigma.psi, low.freq = 1, n.intraday = 288)
}
\arguments{
\item{n.days}{number of days}

\item{mu}{mu}

\item{alpha}{alpha}

\item{beta}{beta}

\item{gamma}{gamma}

\item{m}{m}

\item{theta}{theta}

\item{w1}{w1}

\item{w2}{w2}

\item{K}{K}

\item{psi}{psi}

\item{sigma.psi}{sigma.psi}

\item{low.freq}{low.freq}

\item{n.intraday}{n.intraday}
}
\description{
This function simulates a GARCH-MIDAS model where the short-term GARCH component is replaced by its diffusion limit, see Andersen (1998)
}
\examples{
\dontrun{simulate_mfgarch_diffusion(n.days = 200, mu = 0, alpha = 0.06, beta = 0.92, gamma = 0, m = 0,
theta = 0.1, w1 = 1, w2 = 3, K = 12, psi = 0.98, sigma.psi = 0.1, low.freq = 10)}
}
\keyword{simulate_mfgarch}
