% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{mgc.sims.spiral}
\alias{mgc.sims.spiral}
\title{Spiral Simulation}
\usage{
mgc.sims.spiral(n, d, eps = 0.4, a = 0, b = 5)
}
\arguments{
\item{n}{the number of samples for the simulation.}

\item{d}{the number of dimensions for the simulation setting.}

\item{eps}{the noise level for the simulation. Defaults to \code{0.5}.}

\item{a}{the lower limit for the data matrix. Defaults \code{-1}.}

\item{b}{the upper limit for the data matrix. Defaults to \code{1}.}
}
\value{
a list containing the following:
\item{\code{X}}{\code{[n, d]} the data matrix with \code{n} samples in \code{d} dimensions.}
\item{\code{Y}}{\code{[n]} the response array.}
}
\description{
A function for Generating a spiral simulation.
}
\section{Details}{

Given: \eqn{U \sim U(a, b)}{U ~ U(a, b)} a random variable.
Simumlates \eqn{n} points from \eqn{Spiral(X, Y) \in \mathbf{R}^d \times \mathbf{R}}{Spiral(X, Y)} where:
\eqn{X_i = U\, \textrm{cos}(\pi\, U)^d}{Xi = U*cos(pi*U)^d} if \code{i = d}, and \eqn{U\, \textrm{sin}(\pi U)\textrm{cos}^i(\pi U)}{sin(pi*U)*cos(pi*U)^i} otherwise
\deqn{Y = U\, \textrm{sin}(\pi\, U) + \epsilon p N(0, 1)}{Y = U*sin(pi*U) + eps*p*N(0, 1)}

For more details see the help vignette:
\code{vignette("sims", package = "mgc")}
}

\examples{
library(mgc)
result  <- mgc.sims.spiral(n=100, d=10)  # simulate 100 samples in 10 dimensions
X <- result$X; Y <- result$Y
}
\author{
Eric Bridgeford
}
