% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gamViz.R
\name{check.gamViz}
\alias{check.gamViz}
\title{Some diagnostics for a fitted gam model}
\usage{
\method{check}{gamViz}(
  obj,
  type = c("auto", "deviance", "pearson", "response", "tunif", "tnormal"),
  k.sample = 5000,
  k.rep = 200,
  maxpo = 10000,
  a.qq = list(),
  a.hist = list(),
  a.respoi = list(),
  ...
)
}
\arguments{
\item{obj}{an object of class \code{gamViz}, the output of a \code{getViz()} call.}

\item{type}{type of residuals, see \link{residuals.gamViz}, used in all plots.}

\item{k.sample}{above this k testing uses a random sub-sample of data.}

\item{k.rep}{how many re-shuffles to do to get p-value for k testing.}

\item{maxpo}{maximum number of residuals points that will be plotted in the scatter-plots.
If number of datapoints > \code{maxpo}, then a subsample of \code{maxpo} points will be plotted.}

\item{a.qq}{list of arguments to be passed to \code{qq.gamViz}. See \link{qq.gamViz}.}

\item{a.hist}{list of arguments to be passed to \code{ggplot2::geom_histogram}.}

\item{a.respoi}{list of arguments to be passed to \code{ggplot2::geom_point}.}

\item{...}{currently not used.}
}
\value{
An object of class \code{checkGam}, which is simply a list of \code{ggplot} objects.
}
\description{
Takes a fitted GAM model and produces some diagnostic information about the fitting
procedure and results. The default is to produce 4 residual plots, some information about
the convergence of the smoothness selection optimization, and to run diagnostic tests of
whether the basis dimension choises are adequate.
}
\details{
This is a essentially a re-write of \code{mgcv::gam.check} using \code{ggplot2}. See
\link[mgcv:gam.check]{mgcv::gam.check} for details.
}
\examples{
library(mgcViz)
set.seed(0)
dat <- gamSim(1, n = 200)
b <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
b <- getViz(b)

# Checks using default options
check(b)

# Change some algorithmic and graphical parameters
check(b,
      a.qq = list(method = "tnorm", 
                  a.cipoly = list(fill = "light blue")), 
      a.respoi = list(size = 0.2), 
      a.hist = list(bins = 10))
}
