% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgss_main.R
\name{MGCG_smooth}
\alias{MGCG_smooth}
\title{High-dimensional spline smoothing using a matrix-free multigrid preconditioned CG-method.}
\usage{
MGCG_smooth(
  G,
  q,
  lambda,
  X,
  y,
  w = 0.1,
  nu = c(3, 1),
  alpha_start = NULL,
  K_max = NULL,
  tolerance = 1e-06,
  print_error = TRUE
)
}
\arguments{
\item{G}{Positive integer for the maximum number of grids.}

\item{q}{Vector of positive integers. Each entry gives the spline degree for the respective covariate.}

\item{lambda}{Positive number as weight for the penalty term.}

\item{X}{Matrix containing the covariates as columns and the units as rows.}

\item{y}{Vector of length \code{nrow(X)} as the variable of interest.}

\item{w}{Damping factor of the Jacobi smoother. Defaults to \code{0.1}.}

\item{nu}{Two-dimensional vector of non-negative integers. Gives the number of pre- and post-smoothing steps in the multigrid algorithm.}

\item{alpha_start}{Vector of length \code{prod(m+q+1)} as starting value for the MGCG-method. Defaults to zero.}

\item{K_max}{Positive integer as upper bound for the number of MGCG-iterations. Defaults to \code{prod(m+q+1)}.}

\item{tolerance}{Positive number as error tolerance for the stopping criterion of the MGCG-method. Defaults to \code{1e-6}.}

\item{print_error}{Logical, indicating if the iteration error should be printed or not.}
}
\value{
Returns a list containing the input \code{m = 2^G-1}, \code{q}, and \code{Omega}. Further gives the fitted spline coefficients \code{alpha}, the fitted values \code{fitted_values}, the residuals \code{residuals}, the root mean squared error \code{rmse} and the R-squared value \code{R_squared}.
}
\description{
Fits a smooth spline to a set of given observations using penalized splines with curvature penalty and multiple covariates. The underlying linear system is solved with a matrix-free preconditioned conjugated gradient method using a geometric multigrid method as preconditioner.
}
\examples{
data <- generate_test_data(100, 2)
X <- data$X_train
y <- data$y_train
MGCG_smooth(G = 3, q = c(3,3), lambda = 0.1, w = 0.8, X = X, y = y)

}
\references{
Siebenborn, M. and Wagner, J. (2019) A Multigrid Preconditioner for Tensor Product Spline Smoothing. arXiv:1901.00654
}
