% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu_multiscale.R
\name{simu_multiscale}
\alias{simu_multiscale}
\title{Estimation of linear and local linear model with spatial autocorrelation model (mgwrsar).}
\usage{
simu_multiscale(n=1000,myseed=1,type='GG2024',b0_constant=FALSE)
}
\arguments{
\item{n}{An integer number of observations.}

\item{myseed}{An integer seed used for the simulation.}

\item{type}{Type of DGP used 'FT2017', 'Gao2021' or 'GG2024', default 'GG2024'.}

\item{b0_constant}{A boolean parameter indicating whether the intercept term
should be spatially varying (TRUE) or not (FALSE).}
}
\value{
A named list with simulated data ('mydata') and coords ('coords')
}
\description{
The simu_multiscale function is designed for simulating a spatially varying
coefficient DGP (Data Generating Process) based on formulations proposed by
Fotheringam et al. (2017), Gao et al. (2021), or Geniaux (2024).
}
\examples{
\donttest{
 library(mgwrsar)
 library(ggplot2)
 library(gridExtra)
 library(grid)
 simu=simu_multiscale(1000)
 mydata=simu$mydata
 coords=simu$coords
 p1<-ggplot(mydata,aes(x,y,col=Beta1))+geom_point() +scale_color_viridis_c()
 p2<-ggplot(mydata,aes(x,y,col=Beta2))+geom_point() +scale_color_viridis_c()
 p3<-ggplot(mydata,aes(x,y,col=Beta3))+geom_point() +scale_color_viridis_c()
 p4<-ggplot(mydata,aes(x,y,col=Beta4))+geom_point() +scale_color_viridis_c()
 grid.arrange(p1,p2,p3,p4,nrow=2,ncol=2, top = textGrob("DGP Geniaux (2024)"
 ,gp=gpar(fontsize=20,font=3)))
}
}
