% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genClaytonReg.R
\name{tvc.example}
\alias{tvc.example}
\title{Creates an example of a matrix of time-varying covariates}
\usage{
tvc.example(Y1, Y2, Delta1, Delta2, X)
}
\arguments{
\item{Y1, Y2}{Vectors of event times (continuous).}

\item{Delta1, Delta2}{Vectors of censoring indicators (1=event,
0=censored).}

\item{X}{Matrix of covariates (continuous or binary).}
}
\value{
A list containing the following elements:
\describe{
\item{ids:}{A vector of ids}
\item{X.tv:}{Time-varying covariate matrix}
}
}
\description{
Given a set of (non-time-varying) covariates, creates a simple example
of a matrix of time-varying covariates that can be used as input data
for the mHR2.tvc function.
}
\section{Details}{

For each (non-time-varying) covariate in X, two time-varying
covariates are created. The first time-varying covariate is equal to
X\emph{log(T1), and the second is equal to X}log(T2). (If T=0, then the
time-varying covariate is set to be 0.) A vector of ID numbers and a
matrix of time-varying covariates are created in a format that can be
passed to the mHR2.tvc function.
}

\examples{
x <- genClaytonReg(250, 2, 0.5, 1, 1, 0, log(2), 0, 5, 5)
x.tv <- tvc.example(x$Y1, x$Y2, x$Delta1, x$Delta2, x$X)
}
\seealso{
\code{\link{mHR2}}, \code{\link{genClaytonReg}}
}
