% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_and_save_files.R
\name{save_plot}
\alias{save_plot}
\title{Save the last generated figure}
\usage{
save_plot(
  plot_file,
  width = NULL,
  height = NULL,
  units = "in",
  dpi = 300,
  device = NULL
)
}
\arguments{
\item{plot_file}{String. File name that the figure
shall be saved to. Can end in either ".png", ".tiff",
".pdf", ".jpeg", or ".bmp". For more information, see the documentation
of \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}

\item{width}{Integer. Optional. Plot width. If \code{width = NULL}, \code{width} is
set to the width of the plotting window.}

\item{height}{Integer. Optional. Plot height If \code{height = NULL}, \code{height} is
set to the height of the plotting window.}

\item{units}{String. Units for \code{width} and \code{height}.}

\item{dpi}{Integer. Resolution for raster graphics such as .pdf-files.}

\item{device}{String or function. Specifies which device to use (such as
"pdf" or \code{cairo_pdf})}
}
\value{
Plot, locally saved.
}
\description{
Save the last generated figure locally.
}
\details{
Saves the last generated figure locally. Wrapper
function of \code{ggsave()} from \pkg{ggplot2}. For further details, please
see ?ggplot2::ggsave.
}
\seealso{
\code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}

Other external data functions: 
\code{\link{read_pubmed_jats}()},
\code{\link{read_pubmed}()},
\code{\link{save_excel}()}
}
\concept{external data functions}
