% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.norm.r
\name{norm.draw}
\alias{.norm.draw}
\alias{norm.draw}
\title{Draws values of beta and sigma by Bayesian linear regression}
\usage{
norm.draw(y, ry, x, ridge = 1e-05, ...)

.norm.draw(y, ry, x, ridge = 1e-05, ...)
}
\arguments{
\item{y}{Incomplete data vector of length \code{n}}

\item{ry}{Vector of missing data pattern (\code{FALSE}=missing,
\code{TRUE}=observed)}

\item{x}{Matrix (\code{n} x \code{p}) of complete covariates.}

\item{ridge}{A small numerical value specifying the size of the ridge used. 
The default value \code{ridge = 1e-05} represents a compromise between stability
and unbiasedness. Decrease \code{ridge} if the data contain many junk variables.
Increase \code{ridge} for highly collinear data.}

\item{...}{Other named arguments.}
}
\value{
A \code{list} containing components \code{coef} (least squares estimate),
\code{beta} (drawn regression weights) and \code{sigma} (drawn value of the 
residual standard deviation).
}
\description{
This function draws random values of beta and sigma under the Bayesian 
linear regression model as described in Rubin (1987, p. 167). This function
can be called by user-specified imputation functions.
}
\author{
Stef van Buuren, Karin Groothuis-Oudshoorn, 2000
}
\references{
Rubin, D.B. (1987). \emph{Multiple imputation for nonresponse in surveys}. New York: Wiley.
}

