% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnaManipulate.R
\name{translate}
\alias{translate}
\title{Translation according to the standard genetic code}
\usage{
translate(nuc.sequences, M.start = TRUE)
}
\arguments{
\item{nuc.sequences}{Character vector containing the nucleotide sequences.}

\item{M.start}{A logical indicating if the amino acid sequence should start with M regardless of 
start codon (ATG, GTG or TTG).}
}
\value{
A character vector of translated sequences.
}
\description{
The translation from DNA(RNA) to amino acid sequence according to the standard genetic code.
}
\details{
This function uses the Biostrings::translate function.
}
\examples{
ex.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.fasta")
fdta <- readFasta(ex.file)
translate(fdta$Sequence)

}
\author{
Lars Snipen and Kristian Hovde Liland.
}
