% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_theme.R
\name{color.theme}
\alias{color.theme}
\alias{plot.color.theme}
\alias{print.color.theme}
\title{Color Themes for Graphics}
\usage{
color.theme(
  colors,
  type = c("sequential", "qualitative", "diverging"),
  name = NULL,
  pkg = NULL,
  ...
)

\method{plot}{color.theme}(x, n = NULL, text = x$name, ...)

\method{print}{color.theme}(x, display = TRUE, ...)
}
\arguments{
\item{colors}{one of the following: a color theme name such as "Viridis" with the optional suffix "_r" for color themes in reverse order ("Viridis_r"), a character vector of color names, a palette function, or a ramp function to be used to create a color theme.}

\item{type}{a character string specifying the type of the color theme: One of "sequential", "qualitative" or "diverging".}

\item{name}{an optional character string, specifying the name of the color theme.}

\item{pkg}{an optional character string, specifying the package in which the palette is to be searched for. Available options include "viridisLite", "RColorBrewer", "khroma", "grDevices" and "midr".}

\item{...}{optional arguments to be passed to palette or ramp functions.}

\item{x}{a "color.theme" object to be displayed.}

\item{n}{integer. the number of colors.}

\item{text}{a character string to be displayed.}

\item{display}{logical. If \code{TRUE}, colors are displayed in the plot area.}
}
\value{
\code{color.theme()} returns a "color.theme" object containing following components:
\item{ramp}{the function that takes a numeric vector \code{x} of the values within [0, 1] and returns a color name vector.}
\item{palette}{the function that takes an integer \code{n} and returns a color name vector of length \code{n}.}
\item{type}{the type of the color theme; "sequential", "diverging" or "qualitative".}
\item{name}{the name of the color theme.}
}
\description{
\code{color.theme()} returns an object of class "color.theme" that provides two types of color functions.
}
\details{
"color.theme" objects is a container of the two types of color functions: \code{palette(n)} returns a color name vector of length \code{n}, and \code{ramp(x)} returns color names for each values of \code{x} within [0, 1].
Some color themes are "qualitative" and do not contain \code{ramp()} function.
The color palettes implemented in the following packages are available: \code{grDevices}, \code{viridisLite}, \code{RColorBrewer} and \code{khroma}.
}
\examples{
ct <- color.theme("Mako")
ct$palette(5L)
ct$ramp(seq.int(0, 1, 1/4))
ct <- color.theme("RdBu")
ct$palette(5L)
ct$ramp(seq.int(0, 1, 1/4))
ct <- color.theme("Tableau 10")
ct$palette(10L)
pals <- c("midr", "grayscale", "bluescale", "shap", "DALEX")
pals <- unique(c(pals, hcl.pals(), palette.pals()))
pals <- lapply(pals, color.theme)
old.par <- par(no.readonly = TRUE)
par(mfrow = c(5L, 2L))
for (pal in pals) plot(pal, text = paste(pal$name, "-", pal$type))
par(old.par)
}
