% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mid_breakdown.R
\name{plot.mid.breakdown}
\alias{plot.mid.breakdown}
\title{Plot MID Breakdown with graphics Package}
\usage{
\method{plot}{mid.breakdown}(
  x,
  type = c("waterfall", "barplot", "dotchart"),
  theme = NULL,
  terms = NULL,
  max.bars = 15L,
  width = NULL,
  vline = TRUE,
  catchall = "others",
  format = c("\%t=\%v", "\%t"),
  ...
)
}
\arguments{
\item{x}{a "mid.breakdown" object to be visualized.}

\item{type}{a character string specifying the type of the plot. One of "barplot" or "dotchart".}

\item{theme}{a character string specifying the color theme or any item that can be used to define "color.theme" object.}

\item{terms}{an optional character vector specifying the terms to be displayed.}

\item{max.bars}{an integer specifying the maximum number of bars in the barplot, boxplot and dotchart.}

\item{width}{a numeric value specifying the width of the bars.}

\item{vline}{logical. If \code{TRUE}, the vertical line is drawn at zero or the intercept.}

\item{catchall}{a character string to be used as the catchall label.}

\item{format}{a character string or character vector of length two to be used as the format of the axis labels. "t" and "v" immediately after the percent sign are replaced with the corresponding term and value.}

\item{...}{optional parameters to be passed to the graphing function. Possible arguments are "col", "fill", "pch", "cex", "lty", "lwd" and aliases of them.}
}
\value{
\code{plot.mid.breakdown()} produces a plot and returns \code{NULL}.
}
\description{
For "mid.breakdown" objects, \code{plot()} visualizes the breakdown of a prediction by component functions.
}
\details{
The S3 method of \code{plot()} for "mid.breakdown" objects creates a visualization of the MID breakdown using the functions of the graphics package.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4)
mid <- interpret(price ~ (carat + cut + color + clarity)^2, diamonds[idx, ])
mbd <- mid.breakdown(mid, diamonds[1L, ])
plot(mbd, type = "waterfall")
plot(mbd, type = "waterfall", theme = "midr")
plot(mbd, type = "barplot", theme = "Set 1")
plot(mbd, type = "dotchart", theme = "Cividis")
}
