% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_yhat.R
\name{get.yhat}
\alias{get.yhat}
\alias{get.yhat.default}
\alias{get.yhat.mid}
\alias{get.yhat.lm}
\alias{get.yhat.glm}
\alias{get.yhat.rpart}
\alias{get.yhat.randomForest}
\alias{get.yhat.ranger}
\alias{get.yhat.svm}
\alias{get.yhat.ksvm}
\alias{get.yhat.AccurateGLM}
\alias{get.yhat.glmnet}
\alias{get.yhat.model_fit}
\alias{get.yhat.rpf}
\title{Wrapper Prediction Function}
\usage{
get.yhat(object, newdata, ...)

\method{get.yhat}{default}(object, newdata, target = -1L, ...)

\method{get.yhat}{mid}(object, newdata, ...)

\method{get.yhat}{lm}(object, newdata, ...)

\method{get.yhat}{glm}(object, newdata, ...)

\method{get.yhat}{rpart}(object, newdata, target = -1L, ...)

\method{get.yhat}{randomForest}(object, newdata, target = -1L, ...)

\method{get.yhat}{ranger}(object, newdata, target = -1L, ...)

\method{get.yhat}{svm}(object, newdata, target = -1L, ...)

\method{get.yhat}{ksvm}(object, newdata, target = -1L, ...)

\method{get.yhat}{AccurateGLM}(object, newdata, ...)

\method{get.yhat}{glmnet}(object, newdata, ...)

\method{get.yhat}{model_fit}(object, newdata, target = -1L, ...)

\method{get.yhat}{rpf}(object, newdata, target = -1L, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{newdata}{a data.frame or matrix.}

\item{...}{optional arguments passed on to the underlying \code{predict()} method for the \code{object}'s class.}

\item{target}{an integer or character vector specifying the target levels used for the classification models that return a matrix or data frame of class probabilities. The default, \code{-1}, represents the probability of not being the base level.}
}
\value{
\code{get.yhat()} returns a numeric vector of model predictions for \code{newdata}.
}
\description{
\code{get.yhat()} is a generic function that provides a unified interface for obtaining predictions from various fitted model objects.
}
\details{
While many predictive models have a \code{stats::predict()} method, the structure and type of their outputs are not uniform.
For example, some return a numeric vector, others a matrix of class probabilities, and some a list.
This function, \code{get.yhat()}, abstracts away this complexity.

For regression models, it returns the numeric prediction in the original scale of the response variable.
For classification models, it returns the sum of class probabilities for the classes specified by the \code{target} argument.

Furthermore, \code{get.yhat()} provides more consistent handling of missing values.
While some \code{stats::predict()} methods may return a shorter vector by omitting \code{NA}s, \code{get.yhat()} is designed to return a vector of the same length as \code{newdata}, preserving \code{NA}s in their original positions.

The design of \code{get.yhat()} is strongly influenced by \code{DALEX::yhat()}.
}
\examples{
data(trees, package = "datasets")
model <- glm(Volume ~ ., trees, family = Gamma(log))

# The output of stats::predict() might not be in the scale of the response variable
predict(model, trees[1:5, ])

# get.yhat() returns a numeric vector in the original scale of the response variable
get.yhat(model, trees[1:5, ])
predict(model, trees[1:5, ], type = "response")
}
\seealso{
\code{\link{predict.mid}}
}
