% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorProxy.R
\name{dict_scalors_proxy}
\alias{dict_scalors_proxy}
\alias{ScalorProxy}
\title{Proxy-Scalor that Scales According to its Configuration parameter}
\description{
\code{\link{Scalor}} that performs the operation in its \code{operation} configuration parameter. This is useful, e.g., to make
\code{\link{SelectorBest}}'s operation fully parametrizable.
}
\section{Configuration Parameters}{

\itemize{
\item \code{operation} :: \code{\link{Scalor}}\cr
Operation to perform. Initialized to \code{\link{ScalorSingleObjective}}.
This is primed when \verb{$prime()} of \code{ScalorProxy} is called, and also when \verb{$operate()} is called, to make changing
the operation as part of self-adaption possible. However, if the same operation gets used inside multiple \code{ScalorProxy}
objects, then it is recommended to \verb{$clone(deep = TRUE)} the object before assigning them to \code{operation} to avoid
frequent re-priming.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Scalor}} can be created with the short access form \code{\link[=scl]{scl()}}
(\code{\link[=scls]{scls()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_scalors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
scl("proxy")
scls("proxy")  # takes vector IDs, returns list of Scalors

# long form:
dict_scalors$get("proxy")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
sp = scl("proxy")
p = ps(x = p_dbl(-5, 5))
# dummy data; note that ScalorOne does not depend on data content
data = data.frame(x = rep(0, 5))
fitnesses = c(1, 5, 2, 3, 0)

sp$param_set$values$operation = scl("one")
sp$prime(p)
sp$operate(data, fitnesses)

}
\seealso{
Other scalors: 
\code{\link{Scalor}},
\code{\link{dict_scalors_aggregate}},
\code{\link{dict_scalors_domcount}},
\code{\link{dict_scalors_fixedprojection}},
\code{\link{dict_scalors_hypervolume}},
\code{\link{dict_scalors_nondom}},
\code{\link{dict_scalors_one}},
\code{\link{dict_scalors_single}}

Other scalor wrappers: 
\code{\link{dict_scalors_aggregate}},
\code{\link{dict_scalors_fixedprojection}}
}
\concept{scalor wrappers}
\concept{scalors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Scalor]{miesmuschel::Scalor}} -> \code{ScalorProxy}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ScalorProxy-new}{\code{ScalorProxy$new()}}
\item \href{#method-ScalorProxy-prime}{\code{ScalorProxy$prime()}}
\item \href{#method-ScalorProxy-clone}{\code{ScalorProxy$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorProxy-new"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorProxy-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{ScalorProxy} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorProxy$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorProxy-prime"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorProxy-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the operator given to the \code{operation} configuration parameter.
Note that this modifies the \verb{$param_set$values$operation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorProxy$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorProxy-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorProxy-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorProxy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
