% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorSwap.R
\name{dict_recombinators_swap}
\alias{dict_recombinators_swap}
\alias{RecombinatorSwap}
\title{Swap Recombinator}
\description{
Values between two individuals are exchanged. This is relatively useless as an operator by itself, but is used
in combination with \code{\link{RecombinatorCmpMaybe}} to get a recombinator that is crossing over individuals
uniformly at random. Because this is such a frequently-used operation, the \code{\link{RecombinatorCrossoverUniform}} pseudo-class
exists as a shortcut.
}
\section{Configuration Parameters}{

None.
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_lgl}} ('ParamLgl'), \code{\link[paradox:Domain]{p_int}} ('ParamInt'), \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl'), \code{\link[paradox:Domain]{p_fct}} ('ParamFct')
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("swap")
recs("swap")  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("swap")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
rs = rec("swap")
p = ps(x = p_int(-5, 5), y = p_dbl(-5, 5), z = p_dbl(-5, 5))
data = data.frame(x = 0:5, y = 0:5, z = 0:5)

rs$prime(p)
rs$operate(data)

rx = rec("cmpmaybe", rec("swap"), p = 0.5)  # the same as 'rec("xounif")'
rx$prime(p)
rx$operate(data)

}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_xonary}},
\code{\link{dict_recombinators_xounif}}
}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{\link[miesmuschel:RecombinatorPair]{miesmuschel::RecombinatorPair}} -> \code{RecombinatorSwap}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorSwap-new}{\code{RecombinatorSwap$new()}}
\item \href{#method-RecombinatorSwap-clone}{\code{RecombinatorSwap$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorSwap-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorSwap-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{RecombinatorCrossoverSwap} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorSwap$new(keep_complement = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keep_complement}}{(\code{logical(1)})\cr
Whether the operation should keep both resulting individuals (\code{TRUE}), or only the first and discard
the complement (\code{FALSE}). Default \code{TRUE}.
The \verb{$keep_complement} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorSwap-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorSwap-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorSwap$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
