% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_od.R
\name{sum_od}
\alias{sum_od}
\title{Extract a Classic Origin-Destination Migration Flow Matrix.}
\usage{
sum_od(y)
}
\arguments{
\item{y}{Array of origin-destination matrices, where the first and second dimensions correspond to origin and destination respectively. Higher dimension(s) refer to additional migrant characteristic(s).}
}
\value{
Matrix from summing over the first and second dimension. Set diagonals to zero.

Returns a \code{matrix} object of origin-destination flows
}
\description{
Extract a classic origin-destination migration flow matrix from a more detailed dis-aggregation of flows stored in an (\code{array}) object.
}
\examples{
dn <- LETTERS[1:2]
y <- cm3(row_tot = c(18, 20) * 2, col_tot = c(16, 22) * 2, 
         m = array(c(5, 1, 2, 7, 4, 2, 5, 9), dim = c(2, 2, 2), 
                   dimnames = list(orig = dn, dest = dn, type = c("ILL", "HEALTHY"))))
round(addmargins(y$N))
round(addmargins(sum_od(y$N))) 
}
\author{
Guy J. Abel
}
