% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_tests.R
\name{tests}
\alias{tests}
\alias{test_random}
\alias{test_permutation}
\title{Conditional uniform graph and permutation tests}
\usage{
test_random(
  object,
  FUN,
  ...,
  times = 1000,
  strategy = "sequential",
  verbose = FALSE
)

test_permutation(
  object,
  FUN,
  ...,
  times = 1000,
  strategy = "sequential",
  verbose = FALSE
)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{FUN}{A graph-level statistic function to test.}

\item{...}{Additional arguments to be passed on to FUN,
e.g. the name of the attribute.}

\item{times}{Integer indicating number of simulations used for quantile estimation.
(Relevant to the null hypothesis test only -
the analysis itself is unaffected by this parameter.)
Note that, as for all Monte Carlo procedures, convergence is slower for more
extreme quantiles.
By default, \code{times=1000}.
1,000 - 10,000 repetitions recommended for publication-ready results.}

\item{strategy}{If \code{{furrr}} is installed,
then multiple cores can be used to accelerate the function.
By default \code{"sequential"},
but if multiple cores available,
then \code{"multisession"} or \code{"multicore"} may be useful.
Generally this is useful only when \code{times} > 1000.
See \href{https://furrr.futureverse.org}{\code{{furrr}}} for more.}

\item{verbose}{Whether the function should report on its progress.
By default FALSE.
See \href{https://progressr.futureverse.org}{\code{{progressr}}} for more.}
}
\description{
These functions conduct conditional uniform graph (CUG)
or permutation (QAP) tests of any graph-level statistic.
}
\section{Functions}{
\itemize{
\item \code{test_random()}: Returns test results for some measure on an object
against a distribution of measures on random networks of the same dimensions

\item \code{test_permutation()}: Returns test results for some measure on an object
against a distribution of measures on permutations of the original network

}}
\examples{
marvel_friends <- to_unsigned(ison_marvel_relationships)
marvel_friends <- to_giant(marvel_friends) \%>\% 
  to_subgraph(PowerOrigin == "Human")
(cugtest <- test_random(marvel_friends, network_homophily, attribute = "Attractive",
  times = 200))
plot(cugtest)
(qaptest <- test_permutation(marvel_friends, 
                network_homophily, attribute = "Attractive",
                times = 200))
plot(qaptest)
}
\seealso{
Other models: 
\code{\link{regression}}
}
\concept{models}
