% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_mpn.R
\docType{data}
\name{mpn_senate112}
\alias{mpn_senate112}
\alias{mpn_senate_dem}
\alias{mpn_senate_rep}
\alias{mpn_senate_over}
\title{Two-mode 112th Congress Senate Voting (Knoke et al. 2021)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, weighted, two-mode network of 114 nodes and 2791 ties
#> # A tibble: 114 x 2
#>   type  name      
#>   <lgl> <chr>     
#> 1 FALSE Baucus    
#> 2 FALSE Begich    
#> 3 FALSE Bennet    
#> 4 FALSE Blumenthal
#> 5 FALSE Boxer     
#> 6 FALSE BrownSh   
#> # i 108 more rows
#> # A tibble: 2,791 x 3
#>    from    to weight
#>   <int> <int>  <dbl>
#> 1     1    52      1
#> 2     1    53      1
#> 3     1    54      1
#> 4     1    55      1
#> 5     1    56      1
#> 6     1    57      1
#> # i 2,785 more rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, weighted, two-mode network of 134 nodes and 3675 ties
#> # A tibble: 134 x 2
#>   type  name     
#>   <lgl> <chr>    
#> 1 FALSE Alexander
#> 2 FALSE Ayotte   
#> 3 FALSE Barrasso 
#> 4 FALSE Baucus   
#> 5 FALSE Blunt    
#> 6 FALSE Boozman  
#> # i 128 more rows
#> # A tibble: 3,675 x 3
#>    from    to weight
#>   <int> <int>  <dbl>
#> 1     1    64      1
#> 2     1    66      1
#> 3     1    67      1
#> 4     1    70      1
#> 5     1    71      1
#> 6     1    72      1
#> # i 3,669 more rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, weighted, two-mode network of 52 nodes and 614 ties
#> # A tibble: 52 x 2
#>   type  name     
#>   <lgl> <chr>    
#> 1 FALSE Baucus   
#> 2 FALSE Cardin   
#> 3 FALSE Carper   
#> 4 FALSE Casey    
#> 5 FALSE Collins  
#> 6 FALSE Feinstein
#> # i 46 more rows
#> # A tibble: 614 x 3
#>    from    to weight
#>   <int> <int>  <dbl>
#> 1     1    21      1
#> 2     1    22      1
#> 3     1    23      1
#> 4     1    24      1
#> 5     1    25      1
#> 6     1    26      1
#> # i 608 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(mpn_senate_dem)

data(mpn_senate_rep)

data(mpn_senate_over)
}
\description{
These datasets list the U.S. Senators who served in the 112th Congress,
which met from January 3, 2011 to January 3, 2013.
Although the Senate has 100 seats, 103 persons served during this period due
to two resignations and a death. However, the third replacement occurred
only two days before the end and cast no votes on the bills investigated
here. Hence, the number of Senators analyzed is 102.

CQ Almanac identified 25 key bills on which the Senate voted during the
112th Congress, and which Democratic and Republican Senators voting “yea”
and “nay” on each proposal.

Lastly, we obtained data on campaign contributions made by 92 PACs from the
Open Secrets Website. We recorded all contributions made during the 2008,
2010, and 2012 election campaigns to the 102 persons who were Senators in
the 112th Congress. The vast majority of PAC contributions to a candidate
during a campaign was for $10,000 (the legal maximum is $5,000 each for a
primary and the general election). We aggregated the contributions across
all three electoral cycles, then dichotomized the sums into no contribution
(0) and any contribution (1).
}
\references{
Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}.
Cambridge University Press. Cambridge University Press.
}
\keyword{datasets}
