.formula.toMIM <- function(mim){
  mim.cmd(paste("# Model", mim))
  mim.cmd(paste("Model", .Formula.as.string(mim)))
}

.varspec.toMIM <- function(data,text=""){
  mim.cmd("clear; clear output")
  mim.cmd(text)
  vs  <- .namesTable.to.varspec (data)
  lapply(vs, function(s){if(!is.null(s)) mim.cmd(s)})
}

### Transfer data to MIM

toMIM <- function(data) UseMethod("toMIM", data)

toMIM.data.frame <- function(data){    ## calls toMIM.gmData
  gmd <- as.gmData(data)
  toMIM(gmd)
}

toMIM.table <- function(data){         ## calls toMIM.gmData
  gmd <- as.gmData(data)
  toMIM(gmd)
}

toMIM.gmData <- function(data){
  mim.cmd("clear; clear output")
  switch(.dataOrigin(data),
         "data.frame"    = {.dataframe.to.mim(data)},
         "suffStats"     = {.suffStats.to.mim(data)},
         "discSuffStats" = {.discSuffStats.to.mim(data)},
         "contSuffStats" = {.contSuffStats.to.mim(data)},
         "table"         = {.table.to.mim(data)}
         )
}

.discSuffStats.to.mim <- function(data){
  .varspec.toMIM(data,text="# Sufficient statistics from 'discSuffStats'")
  dat <- observations(data)

  mim.cmd(paste("Fact", paste(dat$names, dat$levels,collapse=" ")))
  labs <- paste("Labels", data$letter, gsub(' ','',paste('\"',data$name,'\"')))
  lapply(labs, mim.cmd)
  mim.cmd(paste("Statread", paste(data$letter,collapse=" ")))
  mim.cmd(paste(dat$counts))
  mim.cmd("!")
}

.contSuffStats.to.mim <- function(data){
  .varspec.toMIM(data,text="# Sufficient statistics from 'contSuffStats'")
  dat <- observations(data)

  vcv <- diag(dat$stddev) %*% dat$corr %*% diag(dat$stddev)
  vcv.tri <- vcv[upper.tri(vcv,diag=TRUE)]
  value <- c(dat$n, dat$means,vcv.tri)
    
  mim.cmd(paste("Cont",paste(data$letter,collapse=" ")))
  labs <- paste("Labels", data$letter, gsub(' ','',paste('\"',data$name,'\"')))
  lapply(labs, mim.cmd)
  mim.cmd(paste("Statread", paste(data$letter,collapse=" ")))
  mim.cmd(paste(value))
  mim.cmd("!")
}

.list.to.mim <- function(data){
  print(".list.to.mim")
  .varspec.toMIM(data,text="# Sufficient statistics from 'list'")
  dat <- observations(v)
  is.cont <- !any(is.na(match(names(dat),c("means","n","corr","stddev"))))
  is.disc <- !any(is.na(match(names(dat),c("names","levels","counts"))))

  if (is.cont){
    vcv <- diag(dat$stddev) %*% dat$corr %*% diag(dat$stddev)
    vcv.tri <- vcv[upper.tri(vcv,diag=TRUE)]
    value <- c(dat$n, dat$means,vcv.tri)
    
    mim.cmd(paste("Cont",paste(data$letter,collapse=" ")))

    labs <- paste("Labels", data$letter, gsub(' ','',paste('\"',data$name,'\"')))
    lapply(labs, mim.cmd)
    mim.cmd(paste("Statread", paste(data$letter,collapse=" ")))
    mim.cmd(paste(value))
    mim.cmd("!")
  }
  if (is.disc){
    mim.cmd(paste("Fact", paste(dat$names, dat$levels,collapse=" ")))

    labs <- paste("Labels", data$letter, gsub(' ','',paste('\"',data$name,'\"')))
    lapply(labs, mim.cmd)
    mim.cmd(paste("Statread", paste(data$letter,collapse=" ")))
    mim.cmd(paste(dat$counts))
    mim.cmd("!")
  }

}

.table.to.mim <- function(data){
  .varspec.toMIM(data,text="# Sufficient statistics from 'table'")

  ss <- data$letter
  ss <- ss[length(ss):1]
  s  <- paste("Statread", paste(ss, collapse=''))
  mim.cmd(s)
  res <- as.vector(observations(data))
  lapply(.partition.mim.input(res),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    

}


.suffStats.to.mim <- function(data){
  vs <-.namesTable.to.varspec(data)
  s  <- paste("Statread", paste(data$letter, collapse=''))
  res <- observations(data)
  str4     <- unlist( lapply( as.vector(t(res)),
                             .float.to.string, n.digits=5, width=15))    
  mim.cmd("# Suff stats")
  lapply(vs, mim.cmd)
  mim.cmd(s)
  lapply(.partition.mim.input(str4),mim.cmd)
  mim.cmd("!", look.nice=FALSE)    
}


.dataframe.to.mim <- function(data,file="mimR_df2mim"){

  mygetwd <- function()gsub("/","\\\\",getwd())
  
  nt <- as.data.frame(data)
  vs <- .namesTable.to.varspec(nt)

  mdata <- observations(data)
  for (j in 1:ncol(mdata))
    mdata[,j] <- as.numeric(mdata[,j])
  str4     <- unlist( lapply( as.vector(t(mdata)), .float.to.string, n.digits=3,
                             width=2))

  var.letter <- .namesToLetters(names(mdata),nt)

  file <- paste(mygetwd(),"\\",file,sep='')
  
  tmp <- proc.time()
  ##cat("Writing MIM data file (in working dir)", specfile,"... ")
  write("%\n% DATA FILE AUTOMATICALLY GENERATED BY mimR", file, append=FALSE)
  write(paste("% TIME:", date(),  "%"), file, append=TRUE)
  write(paste("% FILE:", file,  "\n%"), file, append=TRUE)

  lapply(vs, write, file,append=TRUE)
  write(paste("Read", paste(var.letter, collapse=' ')), file, append=TRUE)  

  write(str4, file, append=TRUE, ncolumns=20)
  write("!", file, append=TRUE)

  mim.cmd(paste("clear; clear output;"))
  str  <- paste("input", file, ";", sep=' ');
  mim.cmd(str, look.nice=FALSE);  
  #cat("Time taken:", (proc.time()-tmp)[3],"\n")
  return(file)
}

.namesTable.to.varspec <- function(nt){
  #print(".namesTable.to.varspec")
  var.spec <-
    paste(paste("Fact", paste(nt$letter[nt$factor==TRUE],nt$levels[nt$factor==TRUE],
                              collapse=' ')), ";",
          paste("Cont", paste(nt$letter[nt$factor==FALSE],collapse=' '))  )
  
  lab.spec <- paste("Labels", nt$letter,
                    gsub(' ','',paste('\"',nt$name,'\"'))     )

  vallab.list <- NULL

  factor.letter <- nt$letter[nt$factor==TRUE]
  factor.levels <- nt$levels[nt$factor==TRUE]
  if (length(factor.letter)>0){
    vl <- attr(nt, "vallabels")
    for (j in 1:length(factor.letter)){
      x1 <- paste("ValLabel", factor.letter[j])
      x2 <- paste(1:factor.levels[j], gsub(' ','',paste('\"',vl[[j]],'\"')))
      x <- paste(x1,paste(x2,collapse=' '))
      vallab.list <- c(vallab.list, x)
    }
  }
  value<-list("var.spec"=var.spec, "lab.spec"=lab.spec,"vallab.spec"=vallab.list)
}





.partition.mim.input <- function(input,token=NULL){    
  curr     <- input
  n.char   <- 50 
  res <- NULL
    while(sum(nchar(curr))>n.char){
    cs <- cumsum(nchar(curr)+1)
    res <- c(res, paste(curr[cs<=n.char], collapse=' '))
    curr <- curr[!(cs<=n.char)]
  }
  value <- c(res, paste(curr, collapse=' '))
  return(value)
}

