% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.R
\name{md2mm}
\alias{md2mm}
\title{Convert (R) Markdown-syntax text to FreeMind mind map code}
\usage{
md2mm(
  from = NA,
  root = "mindr",
  md_list = FALSE,
  md_braces = FALSE,
  md_bookdown = FALSE,
  md_eq = FALSE,
  md_maxlevel = ""
)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}

\item{root}{Character. The string displayed as the root (center) of the mind map.}

\item{md_list}{Logical. whether to process lists like headings in the Markdown input.}

\item{md_braces}{Logical. Whether to remove \href{https://bookdown.org/yihui/bookdown/cross-references.html}{{#ID}} in the headings of the markdown file (usually in a \href{https://github.com/rstudio/bookdown}{bookdown}> project.}

\item{md_bookdown}{Logical. Whether the R Markdown syntax text is in bookdown style, i.e. \code{# (PART), # (APPENDIX)}, and \code{# References} as an upper level of the Level 1 heading.}

\item{md_eq}{Logical. Whether to include LaTeX equations in the Markdown input when converted to other formats.}

\item{md_maxlevel}{Integer or ''. The maximum level of the markdown headings that are displayed in the mind map.}
}
\value{
FreeMind mind map code, which can be saved as a .mm file and viewed by common mind map software, such as \href{http://freemind.sourceforge.net/wiki/index.php/Main_Page}{FreeMind} and \href{https://www.xmind.net}{XMind}.
}
\description{
Convert (R) Markdown-syntax text to FreeMind mind map code
}
\examples{
input <- system.file("examples/mindr-md.Rmd", package = "mindr")
input_txt <- readLines(input, encoding = "UTF-8")
output_txt <- md2mm(input_txt)
output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".mm")
writeLines(output_txt, output, useBytes = TRUE)
# file.show(input) # Open the input file file.show(output) # Open the output
# file
message("Input:  ", input, "\nOutput: ", output)
# file.remove(output) # remove the output file
}
