% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeDepGraph}
\alias{makeDepGraph}
\title{Create dependency graph from available packages.}
\usage{
makeDepGraph(pkg, availPkgs, repos = getOption("repos"), type = "source",
  path, suggests = TRUE, enhances = FALSE, includeBasePkgs = FALSE, ...)
}
\arguments{
\item{pkg}{Character vector of packages.}

\item{availPkgs}{Vector of available packages.  Defaults to reading this list from CRAN, using \code{\link{available.packages}}}

\item{repos}{URL(s) of the 'contrib' sections of the repositories. Passed to \code{\link{available.packages}}}

\item{type}{Passed to \code{\link{available.packages}}}

\item{path}{Destination download path}

\item{suggests}{If TRUE, retrieves Suggests dependencies (non-recursively)}

\item{enhances}{If TRUE, retrieves Enhances dependencies (non-recursively)}

\item{includeBasePkgs}{If TRUE, include base R packages in results}

\item{...}{Other arguments passed to \code{\link{available.packages}}}
}
\description{
Each package is a node, and a dependency is an edge
}
\examples{

p <- makeDepGraph(
  c("ggplot2", "forecast"), 
  repos = c(CRAN="http://cran.revolutionanalytics.com"), 
  type="source"
  )
if(require(igraph)) plot(p)




availPkgs <- pkgAvail(
  repos = c(CRAN="http://cran.revolutionanalytics.com"),
  type="source"
  )

p <- makeDepGraph(
  c("ggplot2", "forecast"), 
  availPkgs = availPkgs
)

if(require(igraph)) plot(p)

}
\seealso{
pkgDep plot.pkgDepGraph
}

