% Generated by roxygen2 (4.0.1): do not edit by hand
\name{addPackageGithub}
\alias{addPackageGithub}
\title{Add DESCRIPTION information from package on github.}
\usage{
addPackageGithub(pdb = pkgAvail(), repo, username = NULL,
  branch = "master")
}
\arguments{
\item{pdb}{Package database, usually the result of \code{\link{pkgAvail}} or \code{\link{available.packages}}}

\item{repo}{Character vector. Name of repository on github, e.g. \code{"RevolutionAnalytics/checkpoint"}}

\item{username}{Optional character vector. Name of repository on github, e.g. \code{"RevolutionAnalytics/checkpoint"}}

\item{branch}{name of branch, defaults to \code{"master"}}
}
\description{
Downloads the DESCRIPTION file from a package on github, parses the fields and adds (or replaces) a row in the available package database.
}
\examples{

# Create package database

pdb <- cranJuly2014

\dontrun{
  pdb <- pkgAvail(repos=c(CRAN="http://cran.revolutionanalytics.com"))
}

# Overwrite pdb with development version of miniCRAN at github
\dontrun{
  newpdb <- addPackageGithub(pdb=pdb, "andrie/miniCRAN")
  newpdb["miniCRAN", ]
}

# Add package from github that's not currently on CRAN
newpdb <- addPackageGithub(pdb=pdb, repo="RevolutionAnalytics/checkpoint")
newpdb["checkpoint", ]

set.seed(1)
plot(makeDepGraph("checkpoint", availPkgs = newpdb, suggests=TRUE))





}

