# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

#' Update Fire Dataset with Current Date
#'
#' @description
#' The `fires` function creates a copy of the fire dataset and adjusts the dates 
#' to align with the current date while maintaining the original date patterns.
#'
#' @details
#' The function performs the following operations:
#' \itemize{
#'   \item Creates a copy of the fire dataset from the mintyr package
#'   \item Calculates the number of days between the last recorded date and the previous day
#'   \item Shifts all dates forward by the calculated number of days
#'   \item Converts the updated dates back to character format
#' }
#'
#' @return A data.table with updated dates, shifted to the current date
#'
#' @note
#' - Requires the `data.table` and `mintyr` packages
#' - Uses the current system date as a reference for date shifting
#' - Maintains the original structure of the date column
#'
#' @importFrom data.table copy
#' @export
#' @examples
#' head(fires())
fires <- function() {
  Date <- NULL
  data <- data.table::copy(mintyr::fire)
  days_diff <- Sys.Date() - 1 - max(unique(as.Date(data$Date)))
  data[, Date := as.Date(Date)
  ][, `:=`(Date, as.Date(Date) + days_diff)
  ][, Date := as.character(Date)][]
}

