% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{\%>>\%}
\alias{\%>>\%}
\title{Deferred Evaluation Pipe}
\usage{
x \%>>\% f
}
\arguments{
\item{x}{a value that is possibly an 'unresolvedValue'.}

\item{f}{a function that accepts 'x' as its first argument.}
}
\value{
The evaluated result, or if x is an 'unresolvedValue', an
    'unresolvedExpr'.
}
\description{
Pipe a possibly unresolved value forward into a function.
}
\details{
An 'unresolvedExpr' encapsulates the eventual evaluation result.
    Query its \code{$data} element for resolution. Once resolved, the object
    changes into a 'resolvedExpr' and the evaluated result will be available
    at \code{$data}.

    Supports stringing together a series of piped expressions (as per
    the below example).

    \code{\link{unresolved}} may be used on an 'unresolvedExpr' or its
    \code{$data} element to test for resolution.
}
\section{Usage}{


    Usage is similar to R's native \code{|>} pipe.

    \code{x \%>>\% f} is equivalent to \code{f(x)}

    \code{x \%>>\% f()} is equivalent to \code{f(x)}

    \code{x \%>>\% f(y)} is equivalent to \code{f(x, y)}

    Please note that other usage is not supported and it is not a drop-in
    replacement for magrittr's \code{\%>\%} pipe.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai({Sys.sleep(0.5); 1})
b <- m$data \%>>\% c(2, 3) \%>>\% as.character()
b
b$data
Sys.sleep(1)
b$data
b

}

}
