library(mirai)
nanotest <- function(x) invisible(x || stop())

nanotest(daemons("view") == 0L)
nanotest(daemons(1L) == 1L)
m <- mirai({
  q <- m + n + 1L
  q / m
}, m = 2L, n = 3L)
b <- m$data %>>% rnorm %>>% as.character()
nanotest(inherits(call_mirai(m), "mirai"))
nanotest(m$data == 3L)
nanotest(identical(call_mirai(m), m))
nanotest(is_mirai(m))
nanotest(length(b$data) == 3L)
nanotest(is.character(b$data))
df <- data.frame(a = 1, b = 2)
dm <- eval_mirai(as.matrix(df), .args = list(df), .timeout = 2000)
nanotest(is_mirai(call_mirai(dm)))
nanotest(!unresolved(dm))
nanotest(is.matrix(dm$data))
nanotest(is.null(stop_mirai(dm)))
me <- mirai(stop())
nanotest(is_mirai_error(call_mirai(me)[["data"]]) && is_error_value(me$data))
nanotest(daemons("view") == 1L)
nanotest(daemons(0L) == -1L)
nanotest(daemons("view") == 0L)
nanotest(is.null(tryCatch(daemons("error"), error = function(e) NULL)))
Sys.sleep(2L)
