% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{saisei}
\alias{saisei}
\title{Saisei (Regenerate Token)}
\usage{
saisei(i = 1L, force = FALSE, .compute = "default")
}
\arguments{
\item{i}{[default 1L] integer \code{i}th URL to replace.}

\item{force}{[default FALSE] logical value whether to replace the listener
even when there is an existing connection.}

\item{.compute}{[default 'default'] character compute profile (each compute
profile has its own set of daemons for connecting to different resources).}
}
\value{
The regenerated character URL upon success, or else NULL.
}
\description{
When using daemons with dispatcher, regenerates the token for the URL a
    dispatcher socket listens at.
}
\details{
As the specified listener is closed and replaced immediately, this
    function will only be successful if there are no existing connections at
    the socket (i.e. 'online' status shows 0), unless the argument 'force' is
    specified as TRUE.

    If a listener is forced closed while a mirai task is still ongoing, the
    mirai remains unresolved until a new instance connects at the regenerated
    URL, at which time it is retried.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

daemons(1L)
Sys.sleep(1L)
status()
saisei(i = 1L, force = TRUE)
status()

daemons(0)

}

}
