% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PLCI.mirt.R
\name{PLCI.mirt}
\alias{PLCI.mirt}
\title{Compute profiled-likelihood confidence intervals}
\usage{
PLCI.mirt(mod, alpha = 0.05, parnum = NULL, plot = FALSE, npts = 24,
  ...)
}
\arguments{
\item{mod}{a converged mirt model}

\item{alpha}{two-tailed alpha critical level}

\item{parnum}{a numeric vector indicating which parameters to estimate.
Use \code{\link{mod2values}} to determine parameter numbers. If \code{NULL}, all possible
parameters are used}

\item{plot}{logical; plot the parameter relationship in the likelihood space for two parameters?}

\item{npts}{number of points to evaluate and plot if \code{plot = TRUE}}

\item{...}{additional arguments to pass to the estimation functions}
}
\description{
Computes profiled-likelihood based confidence intervals. Supports the inclusion of prior
parameter distributions as well as equality constraints.
}
\examples{
\dontrun{
mirtCluster() #use all available cores to estimate CI's in parallel
dat <- expand.table(LSAT7)
mod <- mirt(dat, 1)

result <- PLCI.mirt(mod)
result

mod2 <- mirt(Science, 1)
result2 <- PLCI.mirt(mod2)
result2

#only estimate CI's slopes
sv <- mod2values(mod2)
parnum <- sv$parnum[sv$name == 'a1']
result3 <- PLCI.mirt(mod2, parnum=parnum)
result3

}
}
\seealso{
\code{\link{boot.mirt}}
}
\keyword{likelihood}
\keyword{profiled}

