% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss.glm.fit.R
\name{miss.glm.fit}
\alias{miss.glm.fit}
\title{Fitting Logistic Regression Models with Missing Values}
\usage{
miss.glm.fit(x, y, control = list())
}
\arguments{
\item{x}{design matrix with missingness \eqn{N \times p}{N * p}.}

\item{y}{response vector \eqn{N \times 1}{N * 1}.}

\item{control}{a list of parameters for controlling the fitting process. For \code{miss.glm.fit} this is passed to \code{\link{miss.glm.control}}.}
}
\value{
a list with following components:
\item{coefficients}{Estimated \eqn{\beta}{\beta}.}
\item{ll}{Observed log-likelihood.}
\item{var.covar}{Variance-covariance matrix for estimated parameters.}
\item{s.err}{Standard error for estimated parameters.}
\item{mu.X}{Estimated \eqn{\mu}{\mu}.}
\item{Sig.X}{Estimated \eqn{\Sigma}{\Sigma}.}
}
\description{
This function is used inside \code{miss.glm} to fit logistic regression model with missing values, by algorithm SAEM.
}
\examples{
## For examples see example(miss.glm)
}
