% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comptest.cor.R
\name{comptest.cor}
\alias{comptest.cor}
\title{Comparision of product-moment correlation coefficients}
\usage{
comptest.cor(x = NULL, y = NULL, z = NULL, group = NULL,
             r.xy = NULL, r.xz = NULL, r.yz = NULL, n = NULL,
             r.1 = NULL, r.2 = NULL, n.1 = NULL, n.2 = NULL,
             alternative = c("two.sided", "less", "greater"),
             conf.level = 0.95, digits = 3, output = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{z}{a numeric vector.}

\item{group}{a numeric vector indiating the group membership.}

\item{r.xy}{alternative specification, product-moment correlation coefficient between \code{x} and \code{y}.}

\item{r.xz}{alternative specification, product-moment correlation coefficient between \code{x} and \code{z}.}

\item{r.yz}{alternative specification, product-moment correlation coefficient between \code{y} and \code{z}.}

\item{n}{alternative specification, number of observations.}

\item{r.1}{alternative specification, product-moment correlation coefficient in group 1.}

\item{r.2}{alternative specification, product-moment correlation coefficient in group 2.}

\item{n.1}{alternative specification, number of observations in group 1.}

\item{n.2}{alternative specification, number of observations in group 2.}

\item{alternative}{a character string describing the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{confidence level of the interval.}

\item{digits}{integer indicating the number of decimal places to be displayed.}

\item{output}{logical: if \code{TRUE}, output is shown.}
}
\value{
Returns an object of class \code{comptest.cor} with following entries:

\tabular{ll}{
  \code{call}      \tab function call \cr
  \code{dat}       \tab data.frame with x, y and z (if available) \cr
  \code{spec}      \tab specification of function arguments \cr
  \code{res}       \tab list with results depending on the analysis (independent of dependent samples),
                        i.e., z (test statistic), pval (significance value),
                        r.xy, r.xz, r.yz, r.1, r.2, diff (difference), n, n.1, n.1,
                        lower (lower limit of CI), upper (upper limit of CI) \cr
}
}
\description{
This function statistically compares product-moment correlation coefficients in
independent and dependent samples.
}
\details{
In dependent samples, the function tests the two-sided null hypothesis H0: \eqn{\rho .xy = \rho .xz} or
the one-sided null hypothesis H0: \eqn{\rho .xy >= \rho .xz} or \eqn{\rho .xy <= \rho .xz}. Function parameters
are specified using either (\code{x}, \code{y}, \code{z}) or (\code{r.xy}, \code{r.xz}, \code{r.yz}, \code{n}).
In independent samples, the function tests the two-sided null hypothesis H0: \eqn{\rho.1 = \rho.2} or
the one-sided null hypothesis H0: \eqn{\rho.1 >= \rho.2} or \eqn{\rho.1 <= \rho.2}. Function parameters
are specified using either (\code{x}, \code{y}, \code{group}) or (\code{r.1}, \code{r.2}, \code{n.1}, \code{n.2}).
}
\examples{
# Dependent samples: Generate random data
x <- c(3, 2, 2, 3, 7, 8, 5, 9)
y <- c(2, 4, 1, 5, 7, 3, 6, 7)
z <- c(1, 4, 3, 3, 1, 4, 2, 5)

#--------------------------------------
# Dependent samples
# H0: rho.xy == rho.xz,  H1: rho.xy != rho.xz

comptest.cor(x, y, z)

#--------------------------------------
# Dependent samples
# H0: rho.xy <= rho.xz,  H1: rho.xy > rho.xz
# r.xy = 0.44, r.xz = 0.21. r.yz = 0.20, n = 120

comptest.cor(r.xy = 0.44, r.xz = 0.21, r.yz = 0.20, n = 120,
             alternative = "greater")

###

# Independent samples: Generate random data
dat <- data.frame(group = rep(1:2, each = 200),
                  rbind(sim.cor(200, rho = 0.3),
                        sim.cor(200, rho = 0.5)))

#--------------------------------------
# Independent samples
# H0: rho.1 == rho.2, H1: rho.1 != rho.2

comptest.cor(x = dat$x, y = dat$y, group = dat$group)

#--------------------------------------
# Independent samples
# H0: rho.1 >= rho.2, H1: rho.1 ! < rho.2
# Group 1: r = 0.32, n = 108
# Group 2: r = 0.56, n = 113

comptest.cor(r.1 = 0.32, n.1 = 108, r.2 = 0.56, n.2 = 113,
             alternative = "less")
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Zou, G. Y. (2007). Toward using confidence intervals to compare correlation. \emph{Psychological Methods, 12}, 399-413.
}
\seealso{
\code{\link{test.cor}}, \code{\link{seqtest.cor}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
