% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgrepl.R
\name{mgrepl}
\alias{mgrepl}
\title{Multiple Pattern Matching and Replacement}
\usage{
mgrepl(patterns, text, log.fun = all, na.replace = FALSE,
  use.which = FALSE, cores = 1, ...)
}
\arguments{
\item{patterns}{A vector or list containing regular expressions
(\link{regex}) to be searched in \code{text}. Coerced to \code{character}.}

\item{text}{Character vector on which the search is performed.}

\item{log.fun}{A function to apply on the result of matching each pattern
on each element of \code{text}. Determines the output. See section \bold{Value}.}

\item{na.replace}{A single value to replace each \code{NA} with in the result.}

\item{use.which}{A logical value.
\code{TRUE} to convert result with \link{which}.
Only if output \link{is.atomic}, otherwise ignored. Deprecated.}

\item{cores}{Numeric value for how many cores to use for computation using 
\code{mclapply}.}

\item{\dots}{Further arguments passed to functions \link{grepl}.}
}
\value{
Depending on the function defined with \code{log.fun}, the return value is either
\itemize{
\item a \code{vector}, e.g. for functions like \link{any}, \link{all} or \link{sum}.
\item a \code{matrix} is obtained with e.g. \link{identity} or \link{as.integer}. Each
row holds the result of a single pattern.
\item a \code{list} is returned for functions which create results of different lengths
for each element, such as \link{which}.
}
}
\description{
\code{mgrepl} allows multiple patterns search in character vectors,
offering multicore support to parallelize search over all \code{patterns}
using \link[parallel]{mclapply}.
}
\examples{
#

# strings
s <- c("ab","ac","bc", NA)

# match all patterns (default)
mgrepl(c("a", "b"), s)

# match any of the patterns
mgrepl(c("a", "b"), s, any)
grepl("a|b", s)

# return logical matrix, one column for each pattern
mgrepl(c("a", "b"), s, identity)

# return count of matches
mgrepl(c("a", "b"), s, sum)

#
}
\seealso{
\link{grepl}, \link{mclapply}
}
\author{
Sven E. Templer
}
\keyword{grepl}
\keyword{multiple}
\keyword{regex}
