% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_in_classes.R
\name{impute_hot_deck_in_classes}
\alias{impute_hot_deck_in_classes}
\title{Hot deck imputation in imputation classes}
\usage{
impute_hot_deck_in_classes(
  ds,
  cols_class,
  type = "cols_seq",
  breaks = Inf,
  use_quantiles = FALSE,
  min_objs_in_class = 1,
  min_obs_comp = 0,
  min_obs_per_col = 1,
  donor_limit = Inf,
  add_imputation_classes = FALSE
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{cols_class}{Columns that are used for constructing the imputation
classes.}

\item{type}{The type of hot deck (for details, see \code{\link[=impute_sRHD]{impute_sRHD()}}).}

\item{breaks}{Number of intervals / levels a column is broken into (see
\code{\link[=cut]{cut()}}, which is used internally for cutting numeric columns). If \code{breaks = Inf} (the default), every unique value of a column can be in a separate
class (if no other restrictions apply).}

\item{use_quantiles}{Should quantiles be used for cutting numeric vectors?
Normally, \code{\link[=cut]{cut()}} divides the range of an vector into equal spaced
intervals. If \code{use_quantiles = TRUE}, the classes will be of roughly equal
content.}

\item{min_objs_in_class}{Minimum number of objects (rows) in an imputation class.}

\item{min_obs_comp}{Minimum number of completely observed objects (rows) in an
imputation class.}

\item{min_obs_per_col}{Minimum number of observed values in every column of
an imputation class.}

\item{donor_limit}{Minimum odds between incomplete and complete values in a
column, if \code{type = cols_seq}. If \code{type = sim_comp}, minimum odds between
incomplete and complete rows. For \code{type = sim_part} the donor limit option
is not implemented and \code{donor_limit} should be \code{Inf}.}

\item{add_imputation_classes}{Should imputation classes be added as
attributes to the imputed dataset?}
}
\value{
An object of the same class as \code{ds} with imputed missing values.
}
\description{
Impute missing values in a data frame or a matrix using a hot deck within
imputation classes
}
\details{
This function is a combination of \code{\link[=impute_in_classes]{impute_in_classes()}} and \code{\link[=impute_sRHD]{impute_sRHD()}}.
It applies \code{\link[=impute_sRHD]{impute_sRHD()}} inside of imputation classes (adjustment cells),
which are constructed via \code{\link[=impute_in_classes]{impute_in_classes()}}. More details can be found in
these two functions.
}
\examples{
impute_hot_deck_in_classes(data.frame(
  X = c(rep("A", 10), rep("B", 10)),
  Y = c(rep(NA, 5), 106:120)
),
"X",
donor_limit = 1
)
}
\references{
Andridge, R.R. and Little, R.J.A. (2010), A Review of Hot Deck Imputation for
Survey Non-response. International Statistical Review, 78: 40-64.
doi:10.1111/j.1751-5823.2010.00103.x
}
\seealso{
\code{\link[=impute_in_classes]{impute_in_classes()}}, which is used for the construction of the imputation
classes.

\code{\link[=impute_sRHD]{impute_sRHD()}}, which is used for the imputation.
}
