% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-networkSampler.R
\name{networkSampler}
\alias{networkSampler}
\title{Definition of R6 Class 'networkSampling_sampler'}
\description{
Definition of R6 Class 'networkSampling_sampler'

Definition of R6 Class 'networkSampling_sampler'
}
\details{
This class is use to define a sampling model for a network. Inherits from 'networkSampling'.
Owns a rSampling method which takes an adjacency matrix as an input and send back an object
with class partlyObservedNetwork.
}
\seealso{
\code{\link{partlyObservedNetwork}}
}
\section{Super class}{
\code{\link[missSBM:networkSampling]{missSBM::networkSampling}} -> \code{networkSampler}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{samplingMatrix}}{a matrix of logical indicating observed entries}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{networkSampler$new()}}
\item \href{#method-rSamplingMatrix}{\code{networkSampler$rSamplingMatrix()}}
\item \href{#method-clone}{\code{networkSampler$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="missSBM" data-topic="networkSampling" data-id="print">}\href{../../missSBM/html/networkSampling.html#method-print}{\code{missSBM::networkSampling$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="missSBM" data-topic="networkSampling" data-id="show">}\href{../../missSBM/html/networkSampling.html#method-show}{\code{missSBM::networkSampling$show()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for networkSampling
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{networkSampler$new(type = NA, parameters = NA, nbNodes = NA, directed = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character for the type of sampling. must be in ("dyad", "covar-dyad", "node", "covar-node", "block-node", "block-dyad", "double-standard", "degree")}

\item{\code{parameters}}{the vector of parameters associated to the sampling at play}

\item{\code{nbNodes}}{number of nodes in the network}

\item{\code{directed}}{logical, directed network of not}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rSamplingMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-rSamplingMatrix}{}}}
\subsection{Method \code{rSamplingMatrix()}}{
a method for drawing a sampling matrix according to the current sampling design
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{networkSampler$rSamplingMatrix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{networkSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
