% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.R
\name{diagnostic}
\alias{diagnostic}
\title{Diagnostic checks for assessing MCMC convergence of Bayesian models fitted in \code{JAGS} using the function \code{\link{selection}}, \code{\link{pattern}} or \code{\link{hurdle}}}
\usage{
diagnostic(x, type = "histogram", param = "all", theme = NULL, ...)
}
\arguments{
\item{x}{An object of class "missingHE" containing the posterior results of a full Bayesian model implemented using the function \code{\link{selection}}, 
\code{\link{pattern}} or \code{\link{hurdle}}}

\item{type}{Type of diagnostic check to be plotted for the model parameter selected Available choices include: 'histogram' for histogram plots,
'denplot' for density plots, 'traceplot' for trace plots, 'acf' for autocorrelation plots, 'running' for running mean plots,
'compare' for comparing the distribution of the whole chain with only its last part, 'cross' for crosscorrelation plots, 'Rhat' for the potential scale reduction factor, 'geweke' for the geweke diagnostic,
'pairs' for posterior correlation among the parameters,'caterpillar' for caterpillar plots. In addition the class 'summary' provides an overview of some of the most popular
diagnostic checks for each parameter selected.}

\item{param}{Name of the family of parameters to process, as given by a regular expression. For example the mean parameters 
for the effect and cost variables can be specified using 'mu.e' and 'mu.c', respectively. Different types of
models may have different parameters depending on the assumed distributions and missing data assumptions. 
To see a complete list of all possible parameters by types of models assumed see details.}

\item{theme}{Type of ggplot theme among some pre-defined themes. For a full list of available themes see details.}

\item{...}{Additional parameters that can be provided to manage the graphical output of \code{diagnostic}.}
}
\value{
A \strong{ggplot} object containing the plots specified in the argument \code{type}
}
\description{
The focus is restricted to full Bayesian models in cost-effectiveness analyses based on the function \code{\link{selection}}, \code{\link{pattern}} and \code{\link{hurdle}}, 
with convergence of the MCMC chains that is assessed through graphical checks of the posterior distribution of the parameters of interest,
Examples are density plots, trace plots, autocorrelation plots, etc. Other types of posterior checks are related to some summary MCMC statistics 
that are able to detect possible issues in the convergence of the algorithm, such as the potential scale reduction factor or the effective sample size.
Different types of diagnostic tools and statistics are used to assess model convergence using functions contained in the package \strong{ggmcmc} and \strong{mcmcplots}. 
Graphics and plots are managed using functions contained in the package \strong{ggplot2} and \strong{ggthemes}.
}
\details{
Depending on the types of plots specified in the argument \code{type}, the output of \code{diagnostic} can produce
different combinations of MCMC visual posterior checks for the family of parameters indicated in the argument \code{param}.
For a full list of the available plots see the description of the argument \code{type} or see the corresponding plots in the package \strong{ggmcmc}.

The parameters that can be assessed through \code{diagnostic} are only those included in the object \code{x} (see Arguments). Specific character names
must be specified in the argument \code{param} according to the specific model implemented. The available names and the parameters associated with them are:
\itemize{
\item "mu.e" the mean parameters of the effect variables in the two treatment arms.
\item "mu.c" the mean parameters of the cost variables in the two treatment arms.
\item "mu.e.p" the pattern-specific mean parameters of the effect variables in the two treatment arms (only with the function \code{pattern}).
\item "mu.c.p" the pattern-specific mean parameters of the cost variables in the two treatment arms (only with the function \code{pattern}).
\item "sd.e" the standard deviation parameters of the effect variables in the two treatment arms.
\item "sd.c" the standard deviation parameters of the cost variables in the two treatment arms.
\item "alpha" the regression intercept and covariate coefficient parameters for the effect variables in the two treatment arms.
\item "beta" the regression intercept and covariate coefficient parameters for the cost variables in the two treatment arms.
\item "p.e" the probability parameters of the missingness or structural values mechanism for the effect variables in the two treatment arms 
(only with the function \code{selection} or \code{hurdle}).
\item "p.c" the probability parameters of the missingness or structural values mechanism for the cost variables in the two treatment arms 
(only with the function \code{selection} or \code{hurdle}).
\item "gamma.e" the regression intercept and covariate coefficient parameters of the missingness or structural values mechanism
 for the effect variables in the two treatment arms (only with the function \code{selection} or \code{hurdle}).
\item "gamma.c" the regression intercept and covariate coefficient parameters of the missingness or structural values mechanism 
 for the cost variables in the two treatment arms (only with the function \code{selection} or \code{hurdle}).
\item "pattern" the probabilities associated with the missingness patterns in the data (only with the function \code{pattern}).
\item "delta.e" the mnar parameters of the missingness mechanism for the effect variables in the two treatment arms 
(only with the function \code{selection} or \code{pattern}).
\item "delta.c" the mnar parameters of the missingness mechanism for the cost variables in the two treatment arms 
(only with the function \code{selection} or \code{pattern}).
\item "all" all available parameters stored in the object \code{x}.
}
When the object \code{x} is created using the function \code{pattern}, pattern-specific standard deviation ("sd.e", "sd.c") and regression coefficient 
parameters ("alpha", "beta") for both outcomes can be visualised. The parameters associated with a missingness mechanism can be accessed only when \code{x}
is created using the function \code{selection} or \code{pattern}, while the parameters associated with the model for the structural values mechanism
can be accessed only when \code{x} is created using the function \code{hurdle}.

The argument \code{theme} allows to customise the graphical output of the plots generated by \code{diagnostic} and
allows to choose among a set of possible pre-defined themes taken form the package \strong{ggtheme}. Those available can
be indicated using one of the following character names: "base","calc","economist","excel","few","538","gdocs","hc","par","pander","solarized","stata","tufte","wsj".
}
\examples{
# For examples see the function \\code{\\link{selection}}, 
# \\code{\\link{pattern}} or \\code{\\link{hurdle}}
#
#
}
\references{
Gelman, A. Carlin, JB., Stern, HS. Rubin, DB.(2003). \emph{Bayesian Data Analysis, 2nd edition}, CRC Press.

Brooks, S. Gelman, A. Jones, JL. Meng, XL. (2011). \emph{Handbook of Markov Chain Monte Carlo}, CRC/Chapman and Hall.
}
\seealso{
\code{\link[ggmcmc]{ggs}} \code{\link{selection}} \code{\link{selection}} \code{\link{hurdle}}.
}
\author{
Andrea Gabrio
}
\keyword{MCMC}
\keyword{checks}
\keyword{convergence}
\keyword{diagnostics}
