% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_risk.R
\name{GNG_fit}
\alias{GNG_fit}
\title{Fitting a GPD-Normal-GPD Model}
\usage{
GNG_fit(data, start = c(break1 = -0.02, break2 = 0.02, mean = 0, sd =
  0.0115, shape1 = 0.15, shape2 = 0.15), break_fix = FALSE,
  midd = mean(data), ...)
}
\arguments{
\item{data}{vector of values to which the density is optimized.}

\item{start}{named vector (break1, break2, mean, sd, shape1, shape2) of values that are used to start the optimization,
default: c(break1 = -0.02, break2 = 0.02, mean = 0, sd = 0.0115, shape1 = 0.15,shape2 = 0.15).}

\item{break_fix}{logical, fix the breakpoints at the values from start?, default: FALSE.}

\item{midd}{split reals into two subintervals, the first breakpoint is then optimized on the left of \code{midd} and the second on the right, default: mean(data).}

\item{...}{further arguments to be passed to the optimizer.}
}
\value{
A list of class comp_fit.
}
\description{
\code{GNG_fit} is used to fit three components composite models with components GPD, normal and GPD.
}
\details{
The GNG model is the GPD-Normal-GPD model. This means
         that a \eqn{-X} transformation of a GPD random variable will be used for the left tail,
         normal distribution for the center and again GPD for the right tail.

         The code uses the maximum likelihood estimation technique to estimate the six parameters from the start vector
         (\code{break1, break2, mean, sd, shape1, shape2}). The other parameters (location and scale parameters of the GPD) are
         computed in each step such that the function is continuous. Weights are estimated in every step as a proportion
         of points that correspond to each of the truncated region. If the breakpoints are fixed (i.e. \code{break_fix = TRUE}),
          the weights are computed before the optimization procedure.

         Optimization is handled by the \code{\link[bbmle]{mle2}} function.
}
\examples{
\dontrun{
 GNG_fit(stocks$SAP)

 GNG_fit(stocks$MSFT)

 autoplot(GNG_fit(stocks$ADS))

 GNG_fit(stocks$GSPC, start = c(break1=-0.0075, break2=0.0075, mean=0,
         sd=0.0115, shape1=0.15, shape2=0.15), control = list(maxit = 20000))

 GNG_fit(stocks$DJI, start = c(break1=-0.0055, break2=0.0055, mean=-0.001,
         sd=0.0055,shape1=0.15,shape2=0.15), method = "CG",control = list(maxit = 1000))

}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
