% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.na.descript.R
\name{print.na.descript}
\alias{print.na.descript}
\title{Print na.descript}
\usage{
\method{print}{na.descript}(x, table = x$args$table,
      digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{na.descript} object.}

\item{table}{logical: if \code{TRUE}, a frequency table with number of observed values (\code{"nObs"}),
percent of observed values (\code{"pObs"}), number of missing values (\code{"nNA"}), and
percent of missing values (\code{"pNA"}) is printed for each variable on the console.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying percentages.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{na.descript} object
}
\examples{
dat <- data.frame(x1 = c(1, NA, 2, 5, 3, NA, 5, 2),
                  x2 = c(4, 2, 5, 1, 5, 3, 4, 5),
                  x3 = c(NA, 3, 2, 4, 5, 6, NA, 2),
                  x4 = c(5, 6, 3, NA, NA, 4, 6, NA))

# Descriptive statistics for missing data
dat.na.descript <- na.descript(dat, output = FALSE)

# Print na.descript object with 3 digits
print(dat.na.descript, digits = 3)
}
\seealso{
\code{\link{na.descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
