% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurtosis.R
\name{kurtosis}
\alias{kurtosis}
\title{Excess Kurtosis}
\usage{
kurtosis(x, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns the estimated excess kurtosis of \code{x}.
}
\description{
This function computes the excess kurtosis.
}
\details{
The same method for estimating kurtosis is used in SAS and SPSS. Missing values (\code{NA})
are stripped before the computation. Note that at least 4 observations are needed to compute
excess kurtosis.
}
\examples{
# Set seed of the random number generation
set.seed(123)
# Generate random numbers according to N(0, 1)
x <- rnorm(100)

# Compute excess kurtosis
kurtosis(x)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{skewness}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
