% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.trunc.R
\name{chr.trunc}
\alias{chr.trunc}
\title{Truncate a Character Vector to a Maximum Width}
\usage{
chr.trunc(x, width, side = c("right", "left", "center"), ellipsis = "...",
          check = TRUE)
}
\arguments{
\item{x}{a character vector or factor. Note that factors are converted
into a character vector.}

\item{width}{a numeric value indicating the maximum width of the character
strings in the vector. Note that the default setting
switches to \code{".."} when \code{width = 3}, \code{"."} when
\code{width = 2}, and \code{""} when \code{width = 1}.}

\item{side}{a character string indicating the location of the ellipsis,
i.e. \code{"right"} (default) for the right side, \code{"left"}
for the left side, and \code{"center"} for center of the
character strings in the vector}

\item{ellipsis}{a character string indicating the content of the ellipsis,
i.e., \code{"..."} by default.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}
}
\value{
Returns a truncated character vector.
}
\description{
This function truncates a character vector, so that the number of characters
of each element of the character vector is always less than or equal to the
width specified in the argument \code{width}.
}
\note{
This function was adapted from the \code{str_trunc()} function in the \pkg{stringr}
package by Hadley Wickham (2023).
}
\examples{
# Example 1: Truncate at the right side with a max. of 10 characters
chr.trunc(row.names(mtcars), width = 10)

# Example 2: Truncate at the left side with a max. of 10 characters
chr.trunc(row.names(mtcars), width = 10, side = "left")

# Example 3: Truncate without ellipses
chr.trunc(row.names(mtcars), width = 10, ellipsis = "")
}
\references{
Wickham H (2023). \emph{stringr: Simple, Consistent Wrappers for Common String Operations}.
R package version 1.5.1, https://CRAN.R-project.org/package=stringr
}
\seealso{
\code{\link{chr.color}}, \code{\link{chr.grep}}, \code{\link{chr.grepl}},
\code{\link{chr.gsub}}, \code{\link{chr.omit}}, \code{\link{chr.trim}}
}
\author{
Takuya Yanagida
}
