% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descript.R
\name{descript}
\alias{descript}
\title{Descriptive Statistics}
\usage{
descript(data, ...,
         print = c("all", "default", "n", "nNA", "pNA", "m", "se.m", "var", "sd",
                   "min", "p25", "med", "p75", "max", "range", "iqr", "skew", "kurt"),
         group = NULL, split = NULL, sample = FALSE, sort.var = FALSE,
         na.omit = FALSE, digits = 2, as.na = NULL, write = NULL, append = TRUE,
         check = TRUE, output = TRUE)
}
\arguments{
\item{data}{a numeric vector or data frame with numeric variables,
i.e., factors and character variables are excluded from
\code{data} before conducting the analysis.}

\item{...}{an expression indicating the variable names in \code{data},
e.g., \code{descript(dat, x1, x2, x3)}. Note that the operators
\code{.}, \code{+}, \code{-}, \code{~}, \code{:}, \code{::},
and \code{!} can also be used to select variables, see 'Details'
in the \code{\link{df.subset}} function.}

\item{print}{a character vector indicating which statistical measures to be
printed on the console, i.e. \code{n} (number of observations),
\code{nNA} (number of missing values), \code{pNA} (percentage of
missing values), \code{m} (arithmetic mean), \code{se.m} (standard
error of the arithmetic mean), \code{var} (variance), \code{sd}
(standard deviation), \code{med} (median),\code{min} (minimum),
\code{p25} (25th percentile, first quartile), \code{p75} (75th
percentile, third quartile), \code{max} (maximum),  \code{range}
(range), \code{iqr} (interquartile range), \code{skew} (skewness),
and \code{kurt} (excess kurtosis). The default setting is
\code{print = ("n", "nNA", "pNA", "m", "sd", "min", "max", "skew", "kurt")}.}

\item{group}{a numeric vector, character vector or factor as grouping variable.
Alternatively, a character string indicating the variable name
of the grouping variable in \code{data} can be specified.}

\item{split}{a numeric vector, character vector or factor as split variable.
Alternatively, a character string indicating the variable name
of the split variable in \code{data} can be specified.}

\item{sample}{logical: if \code{TRUE} (default), the univariate sample skewness
or kurtosis is computed, while the population skewness or kurtosis
is computed when \code{sample = FALSE}.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when
specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before
conducting the analysis (i.e., listwise deletion).}

\item{digits}{an integer value indicating the number of decimal places to be
used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis. Note that \code{as.na()} function is only applied
to \code{data}, but not to \code{group} or \code{split}.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extension
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{data}}{list with the input specified in \code{data}, \code{group}, and \code{split}}
\item{\code{args}}{specification of function arguments}
\item{\code{result}}{result table}
}
\description{
This function computes summary statistics for one or more than one variable, optionally
by a grouping and/or split variable.
}
\examples{
#----------------------------------------------------------------------------
# Descriptive statistics

# Example 1a: Descriptive statistics for 'mpg', 'cyl', and 'hp'
descript(mtcars, mpg, cyl, hp)

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")])

# Example 1b: Print all available statistical measures
descript(mtcars, mpg, cyl, hp, print = "all")

# Example 1c: Print default statistical measures plus median
descript(mtcars, mpg, cyl, hp, print = c("default", "med"))

#----------------------------------------------------------------------------
# Grouping and Split Variable

# Example 2a: Grouping variable
descript(mtcars, mpg, cyl, hp, group = "vs")

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")], group = mtcars$vs)

# Example 2b: Split variable
descript(mtcars, mpg, cyl, hp, split = "am")

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")], split = mtcars$am)

# Example 2c: Grouping and split variable
descript(mtcars, mpg, cyl, hp, group = "vs", split = "am")

# Alternative specification without using the '...' argument
descript(mtcars[, c("mpg", "cyl", "hp")], group = mtcars$vs, split = mtcars$am)

#----------------------------------------------------------------------------
# Write Output

\dontrun{
# Example 3a: Text file
descript(mtcars, write = "Descript_Text.txt")

# Example 3b: Excel file
descript(mtcars, write = "Descript_Excel.xlsx")}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.prop}}, \code{\link{ci.prop.diff}}, \code{\link{ci.var}},
\code{\link{ci.sd}}, \code{\link{freq}}, \code{\link{crosstab}},
\code{\link{multilevel.descript}}, \code{\link{na.descript}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
