##
##  PURPOSE:   Return a matrix to be used in layout for given number of figures
##
##  AUTHOR:    Arnost Komarek (LaTeX: Arno\v{s}t Kom\'arek)
##             arnost.komarek[AT]mff.cuni.cz
##
##  CREATED:   28/05/2009
##
##  FUNCTIONS: autolayout (28/05/2009)
##             
## ======================================================================

## *************************************************************
## autolayout
## *************************************************************
autolayout <- function(np)
{
  if (np < 1 | np > 28) stop("not able to determine layout automatically")

  if (np == 1) LAY <- matrix(1, nrow=1, ncol=1)
  else if (np == 2) LAY <- matrix(c(1, 2), nrow=1, byrow=TRUE)
    else if (np == 3) LAY <- matrix(c(0,1,1,0, 2,2,3,3), nrow=2, byrow=TRUE)
      else if (np == 4) LAY <- matrix(c(1,2, 3,4), nrow=2, byrow=TRUE)
        else if (np == 5) LAY <- matrix(c(0,1,1,2,2,0, 3,3,4,4,5,5), nrow=2, byrow=TRUE)
          else if (np == 6) LAY <- matrix(c(1,2,3, 4,5,6), nrow=2, byrow=TRUE)
            else if (np == 7) LAY <- matrix(c(0,1,1,2,2,0, 3,3,4,4,5,5, 0,6,6,7,7,0), nrow=3, byrow=TRUE)
              else if (np == 8) LAY <- matrix(c(0,1,1,2,2,0, 3,3,4,4,5,5, 6,6,7,7,8,8), nrow=3, byrow=TRUE)
                else if (np == 9) LAY <- matrix(c(1,2,3, 4,5,6, 7,8,9), nrow=3, byrow=TRUE)
                  else if (np == 10) LAY <- matrix(c(0,1,1,2,2,3,3,0, 4,4,5,5,6,6,7,7, 0,8,8,9,9,10,10,0), nrow=3, byrow=TRUE)
                    else if (np == 11) LAY <- matrix(c(1,1,2,2,3,3,4,4, 0,5,5,6,6,7,7,0, 8,8,9,9,10,10,11,11), nrow=3, byrow=TRUE)
                      else if (np == 12) LAY <- matrix(c(1,2,3,4, 5,6,7,8, 9,10,11,12), nrow=3, byrow=TRUE)
                        else if (np == 13) LAY <- matrix(c(0,1,1,2,2,3,3,0, 0,4,4,5,5,6,6,0, 0,7,7,8,8,9,9,0, 10,10,11,11,12,12,13,13), nrow=4, byrow=TRUE)
                          else if (np == 14) LAY <- matrix(c(1,1,2,2,3,3,4,4, 0,5,5,6,6,7,7,0, 0,8,8,9,9,10,10,0, 11,11,12,12,13,13,14,14), nrow=4, byrow=TRUE)
                            else if (np == 15) LAY <- matrix(c(0,1,1,2,2,3,3,0, 4,4,5,5,6,6,7,7, 8,8,9,9,10,10,11,11, 12,12,13,13,14,14,15,15), nrow=4, byrow=TRUE)
                              else if (np == 16) LAY <- matrix(c(1,2,3,4, 5,6,7,8, 9,10,11,12, 13,14,15,16), nrow=4, byrow=TRUE)
                                else if (np == 17) LAY <- matrix(c(0,1,1,2,2,3,3,4,4,0, 0,5,5,6,6,7,7,8,8,0, 0,9,9,10,10,11,11,12,12,0, 13,13,14,14,15,15,16,16,17,17), nrow=4, byrow=TRUE)
                                  else if (np == 18) LAY <- matrix(c(1,1,2,2,3,3,4,4,5,5, 0,6,6,7,7,8,8,9,9,0, 0,10,10,11,11,12,12,13,13,0, 14,14,15,15,16,16,17,17,18,18), nrow=4, byrow=TRUE)      
                                    else if (np == 19) LAY <- matrix(c(0,1,1,2,2,3,3,4,4,0, 5,5,6,6,7,7,8,8,9,9, 10,10,11,11,12,12,13,13,14,14, 15,15,16,16,17,17,18,18,19,19), nrow=4, byrow=TRUE)
                                      else if (np == 20) LAY <- matrix(c(1,2,3,4,5, 6,7,8,9,10, 11,12,13,14,15, 16,17,18,19,20), nrow=4, byrow=TRUE)
                                        else if (np == 21) LAY <- matrix(c(0,0,1,1,2,2,3,3,4,4,0,0, 0,5,5,6,6,7,7,8,8,9,9,0, 10,10,11,11,12,12,13,13,14,14,15,15, 16,16,17,17,18,18,19,19,20,20,21,21), nrow=4, byrow=TRUE)
                                          else if (np == 22) LAY <- matrix(c(1,1,2,2,3,3,4,4,5,5,6,6, 0,7,7,8,8,9,9,10,10,11,11,0, 12,12,13,13,14,14,15,15,16,16,17,17, 0,18,18,19,19,20,20,21,21,22,22,0), nrow=4, byrow=TRUE)
                                            else if (np == 23) LAY <- matrix(c(0,1,1,2,2,3,3,4,4,5,5,0, 6,6,7,7,8,8,9,9,10,10,11,11, 12,12,13,13,14,14,15,15,16,16,17,17, 18,18,19,19,20,20,21,21,22,22,23,23), nrow=4, byrow=TRUE)
                                              else if (np == 24) LAY <- matrix(c(1,2,3,4,5,6, 7,8,9,10,11,12, 13,14,15,16,17,18, 19,20,21,22,23,24), nrow=4, byrow=TRUE)
                                                else if (np == 25) LAY <- matrix(c(0,0,1,1,2,2,3,3,4,4,5,5,0,0, 0,6,6,7,7,8,8,9,9,10,10,11,11,0, 12,12,13,13,14,14,15,15,16,16,17,17,18,18, 19,19,20,20,21,21,22,22,23,23,24,24,25,25), nrow=4, byrow=TRUE)
                                                  else if (np == 26) LAY <- matrix(c(0,1,1,2,2,3,3,4,4,5,5,6,6,0, 7,7,8,8,9,9,10,10,11,11,12,12,13,13, 14,14,15,15,16,16,17,17,18,18,19,19,20,20, 0,21,21,22,22,23,23,24,24,25,25,26,26,0), nrow=4, byrow=TRUE)
                                                      else if (np == 27) LAY <- matrix(c(0,1,1,2,2,3,3,4,4,5,5,6,6,0, 7,7,8,8,9,9,10,10,11,11,12,12,13,13, 14,14,15,15,16,16,17,17,18,18,19,19,20,20, 21,21,22,22,23,23,24,24,25,25,26,26,27,27), nrow=4, byrow=TRUE)  
                                                        else if (np == 28) LAY <- matrix(c(1,2,3,4,5,6,7, 8,9,10,11,12,13,14, 15,16,17,18,19,20,21, 22,23,24,25,26,27,28), nrow=4, byrow=TRUE)
  
  return(LAY)
}  
