\name{vac18.simulated}
\encoding{latin1}
\alias{vac18.simulated}

\docType{data}

\title{Simulated data based on the vac18 study for multilevel analysis}

\description{
Simulated data based on the vac18 study to illustrate the use of the multilevel analysis for one and two-factor
analysis with sPLS-DA. This data set contains the expression simulated of 500 genes.
}

\usage{data(vac18.simulated)}

\format{
A list containing the following components:
\describe{
    \item{\code{genes}}{data frame with 48 rows and 500 columns. The simulated expression of 500 genes for
    48 subjects.}
    \item{\code{sample}}{a vector indicating the repeated measurements on each unique subject. See Details.}
    \item{\code{stimulation}}{a factor indicating the stimulation condition on each sample.}
    \item{\code{time}}{a factor indicating the time condition on each sample.}
}
}

\details{
In this cross-over design, repeated measurements are performed 12 experiments units (or unique subjects) for each of the 4 stimulations.

The simulation study was based on a mixed effects model (see reference for details). Ten clusters of 100 genes were generated. Amongt those, 4 clusters of genes discriminate the 4 stimulations (denoted LIPO5, GAG+, GAG- and NS) as follows: \\
-2 gene clusters discriminate (LIPO5, GAG+) versus (GAG-, NS) \\
-2 gene clusters discriminate LIPO5 versus GAG+, while GAG+ and  NS have the same effect \\
-2 gene clusters discriminate GAG- versus NS, while LIPO5 and GAG+ have the same effect \\
-the 4 remaining clusters represent noisy signal (no stimulation effect) \\

Only a subset of those genes are presented here (to save memory space).
}


\references{
Liquet, B., Le Cao, K.-A., Hocini, H. and Thiebaut, R. (2012). A novel approach for biomarker selection and the
integration of repeated measures experiments from two platforms. \emph{BMC Bioinformatics} \bold{13}:325.
}

\keyword{datasets}
