% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmixlnorm.R
\name{rmixlnorm}
\alias{rmixlnorm}
\title{Generating Random Data From A Lognormal Mixture Model}
\usage{
rmixlnorm(n, pi, mu, sd)
}
\arguments{
\item{n}{a positive integer specifying the number of observations we want to generate from the mixture model}

\item{pi}{a numeric vector for the proportion of each component}

\item{mu}{a numeric vector for the mean of each component}

\item{sd}{a numeric vector for the standard deviation of each component}
}
\value{
The function \code{rmixlnorm} returns a numeric vector of random data from the specified lognormal mixture model.
}
\description{
The function \code{rmixlnorm} generates random data from a lognormal mixture model.
}
\details{
The number of random data from each component \eqn{n_0} (a vector) is generated from a multinomial
distribution Multinom\eqn{(n, pi)}. Then the random data from each component is generated with
the sample sized specified in \eqn{n_0} and parameters of lognormal distributions specified in
\code{mu} and \code{sd}.
}
\examples{
x <- rmixlnorm(1000, c(0.4, 0.6), c(2, 5), c(1, 0.5))
hist(x, breaks = 40)

}
\seealso{
\code{\link{rmixnormal}}, \code{\link{rmixweibull}}, \code{\link{rmixgamma}}
}
