\name{getNlsParameterDefaults}
\alias{getNlsParameterDefaults}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Generate a data frame of default values for nonlinear lest-squares
analysis} 
\description{
Convenience function to generate default values for input to the 
\code{doNls} function.  Defaults are indicated by NaN values.  Users 
can manually change these values once the data frame is generated.
}
\usage{
getNlsParameterDefaults(trays)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
    \item{trays}{A vector of tray names that can be generated by the 
        \code{getTrays} function. }
}
\details{
See \code{doNlme} for a description of the parameters.  The data frame 
contains names: 
    \describe{
    \item{param.g}{gamma}
    \item{param.g.std}{Standard deviation of gamma}
    \item{param.p}{psi}
    \item{param.p.std}{Standard deviation of psi}
    \item{param.lambda}{lambda}}
See help for functions \code{doNls} and \code{doNlme} for information on
parameters.  \code{getNlsParameterDefaults} sets all parameter values to 
NaN, instructing the \code{doNls} function to use default values.  After 
generating the data frame, NaNs can be set to numerical values as desired. 
All parameter values except lambda should be in log scale.  
}

\value{
A data frame containing NaN values for all parameter estimates. 
}

\author{John Boik \email{john.boik@newearthbiomed.org}}

\seealso{\code{\link{doNls}}}
\examples{
# mixlowData data object is obtained using the prepareData function
data(mixlowData)
trays <- getTrays(mixlowData)
parameterDefaults <- getNlsParameterDefaults(trays=trays[1:9])
parameterDefaults["t2d1","param.lambda"] <- .05

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ programming } % Fix me

