% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_contexts.R
\name{contexts.covlmc}
\alias{contexts.covlmc}
\title{Contexts of a VLMC with covariates}
\usage{
\method{contexts}{covlmc}(
  ct,
  type = c("auto", "list", "data.frame"),
  reverse = TRUE,
  frequency = NULL,
  counts = c("desc", "local"),
  model = NULL,
  hsize = FALSE,
  metrics = FALSE,
  merging = FALSE,
  ...
)
}
\arguments{
\item{ct}{a fitted covlmc model.}

\item{type}{result type (see details).}

\item{reverse}{logical (defaults to FALSE). See details.}

\item{frequency}{specifies the counts to be included in the result
data.frame. The default value of \code{NULL} does not include anything.
\code{"total"} gives the number of occurrences of each context in the original
sequence. \code{"detailed"} includes in addition the break down of these
occurrences into all the possible states.}

\item{counts}{specifies how the counts reported by \code{frequency} are computed.
The default value \code{"desc"} includes both counts that are specific to the
context (if any) and counts from the descendants of the context in the
tree. When \code{counts = "local"} the counts include only the number of times
the context appears without being the last part of a longer context.}

\item{model}{specifies whether to include the model associated to a each
context. The default result with \code{model=NULL} does not include any model.
Setting \code{model} to \code{"coef"} adds the coefficients of the models in a \code{coef}
column, while \code{"full"} include the models themselves (as R objects) in a
\code{model} column.}

\item{hsize}{if TRUE, adds a \code{hsize} column to the result data frame that
gives for each context the size of the history of covariates used by the model.}

\item{metrics}{if TRUE, adds predictive metrics for each context (see \code{\link[=metrics]{metrics()}}
for the definition of predictive metrics).}

\item{merging}{if TRUE, adds a \code{merged} column to the result data frame. For
a normal context, the value of \code{merged} is FALSE. Contexts that share the same
model have a TRUE \code{merged} value.}

\item{...}{additional arguments for the contexts function.}
}
\value{
the list of the contexts represented in this tree or a data.frame
with more content.
}
\description{
This function returns the different contexts present in a VLMC with
covariates, possibly with some associated data.
}
\details{
The result is a list of all contexts when \code{type="auto"} (or \code{type="list"}),
and no details have been asked via specific parameters (e.g. by setting \code{model}
to a non \code{NULL} value).

Other results are obtained only with \code{type="data.frame"} (or
\code{type="auto"}). See \code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}} for details about the \code{frequency}
parameter. When \code{model} is non \code{NULL}, the resulting \code{data.frame} contains
the models associated to each context (either the full R model or its
coefficients).
}
\section{State order in a context}{
 Notice that contexts are given by default
in the "reverse" order used by the VLMC papers: older values are on the
right. For instance, the context \code{c(0, 1)} is reported if the sequence 1,
then 0 appeared in the time series used to build the context tree. Set
reverse to \code{FALSE} for the reverse convention.
}

\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
breaks <- c(0, median(pc$active_power), max(pc$active_power))
dts <- cut(pc$active_power, breaks = breaks)
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
contexts(m_cov, model = "coef")
contexts(m_cov, model = "full")
}
\seealso{
\code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}}, \code{\link[=contexts.covlmc]{contexts.covlmc()}}.
}
