% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc_likelihood.R
\name{loglikelihood}
\alias{loglikelihood}
\alias{loglikelihood.vlmc}
\title{Log-Likelihood of a VLMC}
\usage{
loglikelihood(vlmc, newdata, ...)

\method{loglikelihood}{vlmc}(vlmc, newdata, ...)
}
\arguments{
\item{vlmc}{the vlmc representation.}

\item{newdata}{an optional discrete time series.}

\item{...}{additional parameters for loglikelihood.}
}
\value{
the log-likelihood of the VLMC with a nobs attribute that accounts for the number of data included in the likelihood calculation.
}
\description{
This function evaluates the log-likelihood of a VLMC fitted on a discrete time series.
When the optional argument \code{newdata} is provided, the function evaluates instead the
log-likelihood for this (new) discrete time series.
}
\details{
For VLMC objects, the method \code{loglikelihood.vlmc} will be used. For VLMC with covariables, \code{loglikelihood.covlmc}
will instead be called. For more informations on \code{loglikelihood} methods, use \code{methods(loglikelihood)} and their associated documentation.
}
\examples{
## Likelihood for a fitted VLMC.
pc <- powerconsumption[powerconsumption$week == 5, ]
breaks <- c(
  0,
  median(powerconsumption$active_power, na.rm = TRUE),
  max(powerconsumption$active_power, na.rm = TRUE)
)
labels <- c(0, 1)
dts <- cut(pc$active_power, breaks = breaks, labels = labels)
m_nocovariate <- vlmc(dts)
ll <- loglikelihood(m_nocovariate)
ll
attr(ll, "nobs")

## Likelihood for a new time series with previously fitted VLMC.
pc_new <- powerconsumption[powerconsumption$week == 11, ]
dts_new <- cut(pc_new$active_power, breaks = breaks, labels = labels)
ll_new <- loglikelihood(m_nocovariate, newdata = dts_new)
ll_new
attributes(ll_new)

}
\seealso{
\link[stats:logLik]{stats::logLik}
}
